/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.TaskReport;
import com.intel.cosbench.exporter.TaskExporter;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTaskExporter
implements TaskExporter {
    protected WorkloadInfo workloadInfo;
    protected DriverInfo driverInfo;
    protected List<TaskReport> driverTasks = new ArrayList<TaskReport>();

    public WorkloadInfo getWorkloadInfo() {
        return this.workloadInfo;
    }

    public void setWorkloadInfo(WorkloadInfo workloadInfo) {
        this.workloadInfo = workloadInfo;
    }

    public DriverInfo getDriverInfo() {
        return this.driverInfo;
    }

    public void setDriverInfo(DriverInfo driverInfo) {
        this.driverInfo = driverInfo;
    }

    @Override
    public void export(Writer writer) throws IOException {
        StageInfo[] stageInfoArray = this.workloadInfo.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo sInfo = stageInfoArray[n2];
            for (TaskReport tReport : sInfo.getTaskReports()) {
                if (!tReport.getDriverUrl().equals(this.driverInfo.getUrl())) continue;
                this.driverTasks.add(tReport);
            }
            ++n2;
        }
        this.writeReport(writer);
    }

    private void writeReport(Writer writer) throws IOException {
        this.writeHeader(writer);
        writer.flush();
        for (TaskReport tReport : this.driverTasks) {
            this.writeMetrics(writer, tReport);
        }
        writer.flush();
    }

    protected abstract void writeHeader(Writer var1) throws IOException;

    protected abstract void writeMetrics(Writer var1, TaskReport var2) throws IOException;
}

