/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.exporter.StageExporter;
import com.intel.cosbench.model.StageInfo;
import java.io.IOException;
import java.io.Writer;

abstract class AbstractStageExporter
implements StageExporter {
    protected StageInfo stage;
    protected int numOpTypes;
    protected Snapshot[] snapshots;

    public void setStage(StageInfo stage) {
        this.stage = stage;
    }

    @Override
    public void export(Writer writer) throws IOException {
        this.snapshots = this.stage.getSnapshots();
        if (this.snapshots == null) {
            return;
        }
        if (this.snapshots.length == 0) {
            return;
        }
        this.numOpTypes = this.snapshots[0].getReport().getSize();
        if (this.numOpTypes == 0) {
            return;
        }
        this.writeReport(writer);
    }

    private void writeReport(Writer writer) throws IOException {
        this.writeHeader(writer);
        writer.flush();
        Snapshot[] snapshotArray = this.snapshots;
        int n = this.snapshots.length;
        int n2 = 0;
        while (n2 < n) {
            Snapshot snapshot = snapshotArray[n2];
            this.writeMetrics(writer, snapshot);
            ++n2;
        }
        writer.flush();
    }

    protected abstract void writeHeader(Writer var1) throws IOException;

    protected abstract void writeMetrics(Writer var1, Snapshot var2) throws IOException;
}

