/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.exporter.MatrixExporter;
import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.IOException;
import java.io.Writer;

abstract class AbstractMatrixExporter
implements MatrixExporter {
    private int idx;
    protected WorkloadInfo workload;

    public void setWorkload(WorkloadInfo workload) {
        this.workload = workload;
    }

    @Override
    public void init(Writer writer) throws IOException {
        this.writeHeader(writer);
        writer.flush();
    }

    protected abstract void writeHeader(Writer var1) throws IOException;

    @Override
    public void export(Writer writer) throws IOException {
        StageInfo[] stageInfoArray = this.workload.getStageInfos();
        int n = stageInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            StageInfo stage = stageInfoArray[n2];
            this.idx = 1;
            for (Metrics metrics : stage.getReport()) {
                this.writeMetrics(writer, stage, metrics, this.idx++);
            }
            ++n2;
        }
        writer.flush();
    }

    protected abstract void writeMetrics(Writer var1, StageInfo var2, Metrics var3, int var4) throws IOException;
}

