/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.exporter;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.exporter.LatencyExporter;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.IOException;
import java.io.Writer;

abstract class AbstractLatencyExporter
implements LatencyExporter {
    protected int[] accs;
    protected int[] sums;
    protected WorkloadInfo workload;

    public void setWorkload(WorkloadInfo workload) {
        this.workload = workload;
    }

    @Override
    public void export(Writer writer) throws IOException {
        this.writeHeader(writer);
        writer.flush();
        int size = 50001;
        Report report = this.workload.getReport();
        int metricsIdx = 0;
        int metricsNum = report.getSize();
        this.sums = new int[metricsNum];
        this.accs = new int[metricsNum];
        for (Metrics metrics : this.workload.getReport()) {
            int sum = 0;
            if (metrics.getLatency() == null) continue;
            int[] data = metrics.getLatency().getHistoData();
            int idx = 0;
            while (idx < size) {
                sum += data[idx];
                ++idx;
            }
            this.sums[metricsIdx++] = sum;
        }
        int idx = 0;
        while (idx < size) {
            this.writeHistogram(writer, idx);
            ++idx;
        }
        writer.flush();
    }

    protected abstract void writeHeader(Writer var1) throws IOException;

    protected abstract void writeHistogram(Writer var1, int var2) throws IOException;
}

