/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.bench;

import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.ReportMerger;
import com.intel.cosbench.bench.Snapshot;

public class SnapshotMerger {
    private int count;
    private double versionSum = 0.0;
    private int minVersion = Integer.MAX_VALUE;
    private int maxVersion = Integer.MIN_VALUE;
    private ReportMerger merger = new ReportMerger();

    public void add(Snapshot snapshot) {
        int version = snapshot.getVersion();
        if (version < this.minVersion) {
            this.minVersion = version;
        }
        if (version > this.maxVersion) {
            this.maxVersion = version;
        }
        ++this.count;
        this.versionSum += (double)version;
        this.merger.add(snapshot.getReport());
    }

    public Snapshot merge() {
        Report report = this.merger.merge();
        Snapshot snapshot = new Snapshot(report);
        snapshot.setVersion(this.getMidVersion());
        snapshot.setMinVersion(this.minVersion);
        snapshot.setMaxVersion(this.maxVersion);
        return snapshot;
    }

    private int getMidVersion() {
        return this.count == 0 ? 0 : (int)(this.versionSum / (double)this.count);
    }
}

