/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.bench;

import com.intel.cosbench.bench.Aggregator;
import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ReportMerger {
    private Set<String> types = new LinkedHashSet<String>();
    private List<Report> children = new ArrayList<Report>();

    public void add(Report report) {
        for (Metrics metrics : report) {
            this.types.add(metrics.getName());
        }
        this.children.add(report);
    }

    public Report merge() {
        Report report = new Report();
        for (String type : this.types) {
            report.addMetrics(this.getMetrics(type));
        }
        return report;
    }

    private Metrics getMetrics(String type) {
        Metrics metrics;
        Aggregator aggregator = new Aggregator(type);
        for (Report report : this.children) {
            metrics = report.getMetrics(type);
            if (metrics == null) continue;
            aggregator.addMetrics(metrics);
        }
        metrics = aggregator.aggregate();
        return metrics;
    }
}

