/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.bench;

import com.intel.cosbench.bench.Histogram;
import com.intel.cosbench.bench.Mark;
import com.intel.cosbench.utils.MapRegistry;

public class Metrics
implements MapRegistry.Item,
Cloneable {
    private String name;
    private String opType;
    private String sampleType;
    private String opName;
    private String opId;
    private int sampleCount;
    private int totalSampleCount;
    private long byteCount;
    private int workerCount;
    private double avgResTime;
    private double avgXferTime;
    private double throughput;
    private double bandwidth;
    private Histogram latency;
    private double ratio;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOpType() {
        return this.opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public String getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(String sampleType) {
        this.sampleType = sampleType;
    }

    public String getOpName() {
        return this.opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public String getOpId() {
        return this.opId;
    }

    public void setOpId(String opId) {
        this.opId = opId;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public int getTotalSampleCount() {
        return this.totalSampleCount;
    }

    public void setTotalSampleCount(int totalSampleCount) {
        this.totalSampleCount = totalSampleCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public double getAvgResTime() {
        return this.avgResTime;
    }

    public void setAvgResTime(double avgResTime) {
        this.avgResTime = avgResTime;
    }

    public double getAvgXferTime() {
        return this.avgXferTime;
    }

    public void setAvgXferTime(double avgXferTime) {
        this.avgXferTime = avgXferTime;
    }

    public double getThroughput() {
        return this.throughput;
    }

    public void setThroughput(double throughput) {
        this.throughput = throughput;
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(double bandwidth) {
        this.bandwidth = bandwidth;
    }

    public Histogram getLatency() {
        return this.latency;
    }

    public void setLatency(Histogram latency) {
        this.latency = latency;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public double getRatio() {
        return this.ratio;
    }

    public Metrics clone() {
        try {
            return (Metrics)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public static String getMetricsType(String opId, String opType, String sampleType, String opName) {
        return String.valueOf(opId) + "." + opType + "." + sampleType + "." + opName;
    }

    public static Metrics newMetrics(String type) {
        String[] types = type.split("\\.");
        Metrics metrics = new Metrics();
        metrics.setName(type);
        metrics.setOpId(types.length > 0 ? types[0] : "na");
        metrics.setOpType(types.length > 1 ? types[1] : "na");
        metrics.setSampleType(types.length > 2 ? types[2] : "na");
        metrics.setOpName(types.length > 3 ? types[3] : "na");
        return metrics;
    }

    public static Metrics convert(Mark mark, long window) {
        int sps = mark.getSampleCount();
        int tsps = mark.getTotalSampleCount();
        long rtSum = mark.getRtSum();
        long xtSum = mark.getXtSum();
        long bytes = mark.getByteCount();
        String type = Metrics.getMetricsType(mark.getOpId(), mark.getOpType(), mark.getSampleType(), mark.getOpName());
        Metrics metrics = Metrics.newMetrics(type);
        metrics.setSampleCount(sps);
        metrics.setTotalSampleCount(tsps);
        metrics.setRatio(metrics.getTotalSampleCount() > 0 ? (double)metrics.getSampleCount() / (double)metrics.getTotalSampleCount() : 0.0);
        metrics.setByteCount(bytes);
        metrics.setWorkerCount(1);
        metrics.setAvgResTime(rtSum > 0L ? (double)rtSum / (double)sps : 0.0);
        metrics.setAvgXferTime(xtSum > 0L ? (double)xtSum / (double)sps : 0.0);
        metrics.setThroughput(sps > 0 ? (double)sps / (double)window * 1000.0 : 0.0);
        metrics.setBandwidth(bytes > 0L ? (double)bytes / (double)window * 1000.0 : 0.0);
        return metrics;
    }
}

