/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.bench;

import com.intel.cosbench.bench.Result;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.utils.MapRegistry;

public class Mark
implements Cloneable,
MapRegistry.Item {
    private String name;
    private String opType;
    private String sampleType;
    private String opName;
    private String opId;
    private int opCount;
    private int sampleCount;
    private int totalOpCount;
    private int totalSampleCount;
    private long rtSum;
    private long xtSum;
    private long byteCount;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOpType() {
        return this.opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public String getOpName() {
        return this.opName;
    }

    public void setOpId(String opId) {
        this.opId = opId;
    }

    public String getOpId() {
        return this.opId;
    }

    public String getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(String sampleType) {
        this.sampleType = sampleType;
    }

    public int getOpCount() {
        return this.opCount;
    }

    public void setOpCount(int opCount) {
        this.opCount = opCount;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public int getTotalOpCount() {
        return this.totalOpCount;
    }

    public void setTotalOpCount(int totalOpCount) {
        this.totalOpCount = totalOpCount;
    }

    public int getTotalSampleCount() {
        return this.totalSampleCount;
    }

    public void setTotalSampleCount(int totalSampleCount) {
        this.totalSampleCount = totalSampleCount;
    }

    public long getRtSum() {
        return this.rtSum;
    }

    public void setRtSum(long rtSum) {
        this.rtSum = rtSum;
    }

    public long getXtSum() {
        return this.xtSum;
    }

    public void setXtSum(long xtSum) {
        this.xtSum = xtSum;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public void clear() {
        this.opCount = 0;
        this.sampleCount = 0;
        this.totalOpCount = 0;
        this.totalSampleCount = 0;
        this.rtSum = 0L;
        this.xtSum = 0L;
        this.byteCount = 0L;
    }

    public void addSample(Sample sample) {
        if (sample.isSucc()) {
            ++this.sampleCount;
            this.rtSum += sample.getTime();
            this.xtSum += sample.getXferTime();
            this.byteCount += sample.getBytes();
        }
        ++this.totalSampleCount;
    }

    public void addOperation(Result result) {
        if (result.isSucc()) {
            ++this.opCount;
        }
        ++this.totalOpCount;
    }

    public static String getMarkType(String opId, String opType, String sampleType, String opName) {
        return String.valueOf(opId) + "." + opType + "." + sampleType + "." + opName;
    }

    public static Mark newMark(String type) {
        String[] types = type.split("\\.");
        Mark mark = new Mark();
        mark.setName(type);
        mark.setOpId(types[0]);
        mark.setOpType(types[1]);
        mark.setSampleType(types[2]);
        mark.setOpName(types[3]);
        return mark;
    }
}

