/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.bench;

import com.intel.cosbench.bench.Counter;

public class Histogram
implements Cloneable {
    private long[] _60;
    private long[] _80;
    private long[] _90;
    private long[] _95;
    private long[] _99;
    private long[] _100;
    private int[] histoData;

    public long[] get_60() {
        return this._60;
    }

    public void set_60(long[] _60) {
        this._60 = _60;
    }

    public long[] get_80() {
        return this._80;
    }

    public void set_80(long[] _80) {
        this._80 = _80;
    }

    public long[] get_90() {
        return this._90;
    }

    public void set_90(long[] _90) {
        this._90 = _90;
    }

    public long[] get_95() {
        return this._95;
    }

    public void set_95(long[] _95) {
        this._95 = _95;
    }

    public long[] get_99() {
        return this._99;
    }

    public void set_99(long[] _99) {
        this._99 = _99;
    }

    public long[] get_100() {
        return this._100;
    }

    public void set_100(long[] _100) {
        this._100 = _100;
    }

    public int[] getHistoData() {
        return this.histoData;
    }

    public void setHistoData(int[] histoData) {
        this.histoData = histoData;
    }

    public void recalcPercentiles() {
        int curr = 0;
        int total = this.calcTotalCount();
        if (total == 0) {
            return;
        }
        int T_99 = (int)((double)total * 0.99);
        int T_95 = (int)((double)total * 0.95);
        int T_90 = (int)((double)total * 0.9);
        int T_80 = (int)((double)total * 0.8);
        int T_60 = (int)((double)total * 0.6);
        int i = 0;
        while (i < this.histoData.length) {
            if ((curr += this.histoData[i]) >= T_99 && this._99 == null) {
                this._99 = Counter.getResTime(i);
            }
            if (curr >= T_95 && this._95 == null) {
                this._95 = Counter.getResTime(i);
            }
            if (curr >= T_90 && this._90 == null) {
                this._90 = Counter.getResTime(i);
            }
            if (curr >= T_80 && this._80 == null) {
                this._80 = Counter.getResTime(i);
            }
            if (curr >= T_60 && this._60 == null) {
                this._60 = Counter.getResTime(i);
            }
            if (curr >= total) {
                this._100 = Counter.getResTime(i);
                break;
            }
            ++i;
        }
    }

    private int calcTotalCount() {
        int total = 0;
        int i = 0;
        while (i < this.histoData.length) {
            total += this.histoData[i];
            ++i;
        }
        return total;
    }

    public Histogram clone() {
        try {
            return (Histogram)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public static Histogram convert(Counter counter) {
        Histogram histogram = new Histogram();
        histogram.setHistoData(Histogram.retrieveData(counter));
        histogram.recalcPercentiles();
        return histogram;
    }

    private static int[] retrieveData(Counter counter) {
        int size = counter.size();
        int[] data = new int[size];
        int i = 0;
        while (i < size) {
            data[i] = counter.get(i);
            ++i;
        }
        return data;
    }
}

