/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.bench;

import com.intel.cosbench.log.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ErrorStatistics {
    private HashMap<String, Exception> stackTraceAndException = new HashMap();
    private HashMap<String, String> stackTraceAndTargets = new HashMap();
    private HashMap<String, String> stackTraceAndMessage = new HashMap();
    private HashMap<String, String> stackTraceAndErrorCode = new HashMap();
    private HashMap<String, String> stackTraceAndNum;
    private HashMap<String, String> stackTraceAndEntireTrace = new HashMap();
    private HashMap<String, Integer> errorCodeAndNum;

    public ErrorStatistics() {
        this.stackTraceAndNum = new HashMap();
        this.errorCodeAndNum = new HashMap();
    }

    public HashMap<String, Exception> getStackTraceAndException() {
        return this.stackTraceAndException;
    }

    public HashMap<String, String> getStackTraceAndTargets() {
        return this.stackTraceAndTargets;
    }

    public HashMap<String, String> getStackTraceAndMessage() {
        return this.stackTraceAndMessage;
    }

    public HashMap<String, String> getStackTraceAndErrorCode() {
        return this.stackTraceAndErrorCode;
    }

    public HashMap<String, String> getStackTraceAndEntireTrace() {
        return this.stackTraceAndEntireTrace;
    }

    public HashMap<String, String> getStackTraceAndNum() {
        return this.stackTraceAndNum;
    }

    public HashMap<String, Integer> getErrorCodeAndNum() {
        return this.errorCodeAndNum;
    }

    public void summaryToMission(Logger logger) {
        Exception e = null;
        String message = null;
        String code = null;
        String trace = "";
        for (Map.Entry<String, String> entry : this.stackTraceAndTargets.entrySet()) {
            e = this.stackTraceAndException.get(entry.getKey());
            if (e != null) {
                message = e.getMessage();
            }
            this.stackTraceAndMessage.put(entry.getKey(), message);
            if (message != null) {
                code = message.substring(9, 12);
            }
            if (!ErrorStatistics.isInteger(code)) {
                code = "N/A";
            }
            this.stackTraceAndErrorCode.put(entry.getKey(), code);
            Integer codeNumber = this.getCodeNumber(entry.getValue());
            this.stackTraceAndNum.put(entry.getKey(), String.valueOf(codeNumber));
            if (this.errorCodeAndNum.containsKey(code)) {
                Integer num = this.errorCodeAndNum.get(code);
                this.errorCodeAndNum.put(code, num + codeNumber);
            } else {
                this.errorCodeAndNum.put(code, codeNumber);
            }
            StackTraceElement[] stackTraceElementArray = this.stackTraceAndException.get(entry.getKey()).getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement ele = stackTraceElementArray[n2];
                trace = String.valueOf(trace) + ele.toString() + "\n";
                ++n2;
            }
            this.stackTraceAndEntireTrace.put(entry.getKey(), trace);
            logger.error("error code: " + code + " occurred " + codeNumber + " times, fail to operate: " + entry.getValue(), (Throwable)this.stackTraceAndException.get(entry.getKey()));
        }
    }

    public Integer getCodeNumber(String targets) {
        if (targets == null) {
            return null;
        }
        int codeNumber = targets.split(",").length;
        return codeNumber;
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        if (str != null && pattern.matcher(str) != null) {
            return pattern.matcher(str).matches();
        }
        return false;
    }
}

