/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.bench;

import java.util.concurrent.atomic.AtomicInteger;

public class Counter {
    public static final long RES_INT = 10L;
    public static final long RES_MAX = 500000L;
    public static final int UL = 50000;
    private AtomicInteger[] counts;

    public Counter(int size) {
        AtomicInteger[] counts = new AtomicInteger[size];
        int i = 0;
        while (i < size) {
            counts[i] = new AtomicInteger(0);
            ++i;
        }
        this.counts = counts;
    }

    public int size() {
        return this.counts.length;
    }

    public int get(int index) {
        return this.counts[index].get();
    }

    public void doAdd(long time) {
        int index = time >= 500000L ? 50000 : (int)(time / 10L);
        this.counts[index].incrementAndGet();
    }

    public static Counter getResCounter() {
        int size = 50001;
        return new Counter(size);
    }

    public static long[] getResTime(int index) {
        if (index >= 50000) {
            return new long[]{500000L, Long.MAX_VALUE};
        }
        return new long[]{(long)index * 10L, (long)(index + 1) * 10L};
    }
}

