/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.bench;

import com.intel.cosbench.bench.Histogram;
import com.intel.cosbench.bench.Metrics;
import java.util.ArrayList;
import java.util.List;

public class Aggregator {
    private String type;
    private int sampleCount = 0;
    private int totalSampleCount = 0;
    private long byteCount = 0L;
    private int workerCount = 0;
    private boolean containsLatency = false;
    private List<Metrics> children = new ArrayList<Metrics>();

    public Aggregator(String type) {
        this.type = type;
    }

    public void addMetrics(Metrics metrics) {
        this.sampleCount += metrics.getSampleCount();
        this.totalSampleCount += metrics.getTotalSampleCount();
        this.byteCount += metrics.getByteCount();
        this.workerCount += metrics.getWorkerCount();
        this.children.add(metrics);
        this.containsLatency = this.containsLatency || metrics.getLatency() != null;
    }

    public Metrics aggregate() {
        Metrics metrics = Metrics.newMetrics(this.type);
        metrics.setSampleCount(this.sampleCount);
        metrics.setTotalSampleCount(this.totalSampleCount);
        metrics.setByteCount(this.byteCount);
        metrics.setWorkerCount(this.workerCount);
        metrics.setThroughput(this.getThroughput());
        metrics.setBandwidth(this.getBandwidth());
        metrics.setAvgResTime(this.getAvgResTime());
        metrics.setAvgXferTime(this.getAvgXferTime());
        metrics.setLatency(this.getLatency());
        metrics.setRatio(metrics.getTotalSampleCount() > 0 ? (double)metrics.getSampleCount() / (double)metrics.getTotalSampleCount() : 0.0);
        return metrics;
    }

    private double getThroughput() {
        double sum = 0.0;
        for (Metrics metrics : this.children) {
            sum += metrics.getThroughput();
        }
        return sum;
    }

    private double getBandwidth() {
        double sum = 0.0;
        for (Metrics metrics : this.children) {
            sum += metrics.getBandwidth();
        }
        return sum;
    }

    private double getAvgResTime() {
        if (this.sampleCount == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (Metrics metrics : this.children) {
            sum += metrics.getAvgResTime() * (double)metrics.getSampleCount();
        }
        return sum / (double)this.sampleCount;
    }

    private double getAvgXferTime() {
        if (this.sampleCount == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (Metrics metrics : this.children) {
            sum += metrics.getAvgXferTime() * (double)metrics.getSampleCount();
        }
        return sum / (double)this.sampleCount;
    }

    private Histogram getLatency() {
        if (!this.containsLatency) {
            return null;
        }
        Histogram histogram = new Histogram();
        histogram.setHistoData(this.getLatencyHistoData());
        histogram.recalcPercentiles();
        return histogram;
    }

    private int[] getLatencyHistoData() {
        int size = 50001;
        int[] data = new int[size];
        for (Metrics metrics : this.children) {
            if (metrics.getLatency() == null) continue;
            int i = 0;
            while (i < size) {
                int n = i;
                data[n] = data[n] + metrics.getLatency().getHistoData()[i];
                ++i;
            }
        }
        return data;
    }
}

