/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.httpauth;

import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.httpauth.HttpAuth;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.util.EntityUtils;

class HttpAuthTest {
    private AbstractHttpClient client = null;
    private String storage_url;

    HttpAuthTest() {
    }

    public boolean getObject(AuthContext context, String conName, String objName) {
        this.storage_url = context.getStr("storage_url");
        this.client = (AbstractHttpClient)context.get("client");
        String url = String.valueOf(this.storage_url) + "/" + conName + "/" + objName;
        HttpGet method = new HttpGet(url);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                return true;
            }
            if (response.getStatusLine().getStatusCode() == 401) {
                System.out.println("unauthorized request!");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                this.dumpResponse(response);
            }
            if (method != null) {
                method.abort();
            }
        }
        return false;
    }

    private void dumpResponse(HttpResponse response) {
        try {
            System.out.println("\nStatus Line");
            System.out.println("-----------");
            System.out.println(response.getStatusLine());
            Header authHeader = response.getFirstHeader("WWW-Authenticate");
            System.out.println("Auth Header = " + authHeader);
            Header authRspHeader = response.getFirstHeader("Authorization");
            System.out.println("Auth Rsp Header = " + authRspHeader);
            System.out.println("\nHeaders");
            System.out.println("-------");
            Header[] headerArray = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                System.out.println(header.toString());
                ++n2;
            }
            System.out.println("\nBody");
            System.out.println("----");
            System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        HttpAuthTest test = new HttpAuthTest();
        HttpAuth auth = new HttpAuth("http://localhost:8080", "cdmi", "mypass", 3000);
        test.getObject(auth.login(), "cdmi-test", "abc.txt");
    }
}

