/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.httpauth;

import com.intel.cosbench.api.auth.AuthException;
import com.intel.cosbench.api.auth.AuthInterruptedException;
import com.intel.cosbench.api.auth.AuthTimeoutException;
import com.intel.cosbench.api.auth.NoneAuth;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.httpauth.HttpAuthContext;
import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.client.httpauth.HttpAuthConstants;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

class HttpAuth
extends NoneAuth {
    private AbstractHttpClient client = null;
    private String auth_url;
    private String username;
    private String password;
    private int timeout;

    public HttpAuth() {
    }

    public HttpAuth(String url, String username, String password, int timeout) {
        this.auth_url = url;
        this.username = username;
        this.password = password;
        this.timeout = timeout;
        this.client = new DefaultHttpClient();
        this.client.getParams().setIntParameter("http.socket.timeout", timeout);
    }

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.auth_url = config.get("auth_url", "http://127.0.0.1:80");
        this.username = config.get("username", "");
        this.password = config.get("password", "");
        this.timeout = config.getInt("timeout", HttpAuthConstants.CONN_TIMEOUT_DEFAULT.intValue());
        logger.debug("using auth config: {}", (Object)this.parms);
        this.client = (DefaultHttpClient)HttpClientUtil.createHttpClient((int)this.timeout);
        logger.debug("httpauth client has been initialized");
    }

    public AuthContext login() {
        URI uri;
        super.login();
        try {
            uri = new URI(this.auth_url);
        }
        catch (URISyntaxException use) {
            throw new AuthException((Throwable)use);
        }
        HttpGet method = new HttpGet(this.auth_url);
        method.getParams().setIntParameter("http.socket.timeout", this.timeout);
        this.client.getCredentialsProvider().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.auth.target-scheme-pref", Arrays.asList("Basic", "Digest"));
        HttpResponse response = null;
        try {
            this.dumpClientSettings();
            response = this.client.execute((HttpUriRequest)method, (HttpContext)localContext);
            this.dumpClientSettings();
            if (response.getStatusLine().getStatusCode() == 200) {
                AuthContext authContext = this.createContext();
                return authContext;
            }
            try {
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new AuthException(response.getStatusLine().getReasonPhrase());
                }
            }
            catch (SocketTimeoutException ste) {
                throw new AuthTimeoutException((Throwable)ste);
            }
            catch (ConnectTimeoutException cte) {
                throw new AuthTimeoutException((Throwable)cte);
            }
            catch (InterruptedIOException ie) {
                throw new AuthInterruptedException((Throwable)ie);
            }
            catch (Exception e) {
                throw new AuthException((Throwable)e);
            }
        }
        finally {
            if (response != null) {
                try {
                    this.dumpResponse(response);
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (Exception ignore) {
                    ignore.printStackTrace();
                }
            }
            if (method != null) {
                method.abort();
            }
        }
        return this.createContext();
    }

    private AuthContext createContext() {
        HttpAuthContext context = new HttpAuthContext(this.auth_url, this.username, this.password, (HttpClient)this.client);
        return context;
    }

    private void dumpClientSettings() {
        System.out.println(this.client.getAuthSchemes().getSchemeNames());
        System.out.println(this.client.getCredentialsProvider());
    }

    private void dumpResponse(HttpResponse response) {
        try {
            System.out.println("\nStatus Line");
            System.out.println("-----------");
            System.out.println(response.getStatusLine());
            Header authHeader = response.getFirstHeader("WWW-Authenticate");
            System.out.println("Auth Header = " + authHeader);
            Header authRspHeader = response.getFirstHeader("Authorization");
            System.out.println("Auth Rsp Header = " + authRspHeader);
            System.out.println("\nHeaders");
            System.out.println("-------");
            Header[] headerArray = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                System.out.println(header.toString());
                ++n2;
            }
            System.out.println("\nBody");
            System.out.println("----");
            System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

