/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.util;

import com.intel.cosbench.config.Config;
import com.intel.cosbench.driver.iterator.Iterators;
import com.intel.cosbench.driver.iterator.NameIterator;
import com.intel.cosbench.driver.util.Defaults;
import com.intel.cosbench.driver.util.Division;

public class ObjectScanner {
    private Division division;
    private NameIterator conNmIter;
    private NameIterator objNmIter;

    public void init(String division, Config config) {
        this.conNmIter = ObjectScanner.getConNmIter(config);
        this.objNmIter = ObjectScanner.getObjNmIter(config);
        this.division = Division.getDivision(division);
    }

    private static NameIterator getConNmIter(Config config) {
        String pattern = config.get("containers");
        String prefix = config.get("cprefix", "mycontainers");
        String suffix = config.get("csuffix", Defaults.CONTAINER_SUFFIX);
        return Iterators.getNameIterator(pattern, prefix, suffix);
    }

    private static NameIterator getObjNmIter(Config config) {
        String pattern = config.get("objects");
        String prefix = config.get("oprefix", "myobjects");
        String suffix = config.get("osuffix", Defaults.OBJECT_SUFFIX);
        return Iterators.getNameIterator(pattern, prefix, suffix);
    }

    public String[] nextObjPath(String[] curr, int idx, int all) {
        if (curr == null) {
            return this.initObjPath(idx, all);
        }
        String objName = this.nextObj(curr[1], idx, all);
        if (objName != null) {
            return new String[]{curr[0], objName};
        }
        String conName = this.nextCon(curr[0], idx, all);
        if (conName != null) {
            return new String[]{conName, this.nextObj(null, idx, all)};
        }
        return null;
    }

    private String nextCon(String curr, int idx, int all) {
        if (!this.division.equals((Object)Division.CONTAINER)) {
            return this.conNmIter.next(curr);
        }
        return this.conNmIter.next(curr, idx, all);
    }

    private String nextObj(String curr, int idx, int all) {
        if (!this.division.equals((Object)Division.OBJECT)) {
            return this.objNmIter.next(curr);
        }
        return this.objNmIter.next(curr, idx, all);
    }

    private String[] initObjPath(int idx, int all) {
        return new String[]{this.nextCon(null, idx, all), this.nextObj(null, idx, all)};
    }
}

