/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.util;

import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.generator.Generators;
import com.intel.cosbench.driver.generator.NameGenerator;
import com.intel.cosbench.driver.util.Defaults;
import com.intel.cosbench.driver.util.Division;
import java.util.Random;

public class ObjectPicker {
    private Division division;
    private NameGenerator conNmGen;
    private NameGenerator objNmGen;

    public void init(String division, Config config) {
        this.conNmGen = ObjectPicker.getConNmGen(config, Boolean.FALSE);
        this.objNmGen = ObjectPicker.getObjNmGen(config, Boolean.FALSE);
        this.division = Division.getDivision(division);
    }

    public void init4Lister(String division, Config config) {
        this.conNmGen = ObjectPicker.getConNmGen(config, Boolean.TRUE);
        this.objNmGen = ObjectPicker.getObjNmGen(config, Boolean.TRUE);
        this.division = Division.getDivision(division);
    }

    private static NameGenerator getConNmGen(Config config, boolean isLister) {
        String pattern;
        String string = pattern = isLister ? config.get("containers", null) : config.get("containers");
        if (pattern == null) {
            return null;
        }
        String prefix = config.get("cprefix", "mycontainers");
        String suffix = config.get("csuffix", Defaults.CONTAINER_SUFFIX);
        return Generators.getNameGenerator(pattern, prefix, suffix);
    }

    private static NameGenerator getObjNmGen(Config config, boolean isLister) {
        String pattern;
        String string = pattern = isLister ? config.get("objects", null) : config.get("objects");
        if (pattern == null) {
            return null;
        }
        String prefix = config.get("oprefix", "myobjects");
        String suffix = config.get("osuffix", Defaults.OBJECT_SUFFIX);
        return Generators.getNameGenerator(pattern, prefix, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] pickObjPath(Random random, int idx, int all) {
        ObjectPicker objectPicker = this;
        synchronized (objectPicker) {
            if (this.division.equals((Object)Division.OBJECT)) {
                return new String[]{this.conNmGen.next(random), this.objNmGen.next(random, idx, all)};
            }
            if (this.division.equals((Object)Division.CONTAINER)) {
                return new String[]{this.conNmGen.next(random, idx, all), this.objNmGen.next(random)};
            }
            return new String[]{this.conNmGen.next(random), this.objNmGen.next(random)};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] pickTargetPath(Random random, int idx, int all) {
        ObjectPicker objectPicker = this;
        synchronized (objectPicker) {
            if (this.conNmGen == null && this.objNmGen != null) {
                throw new ConfigException("no such key defined: containers");
            }
            if (this.conNmGen == null && this.objNmGen == null) {
                return new String[]{"", ""};
            }
            if (this.objNmGen == null) {
                return new String[]{this.conNmGen.next(random, idx, all), ""};
            }
            return new String[]{this.conNmGen.next(random), this.objNmGen.next(random)};
        }
    }
}

