/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.util;

import com.intel.cosbench.driver.util.HashUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.input.NullInputStream;

public class HashedFileInputStream
extends NullInputStream {
    private static final int SIZE = 4096;
    private boolean hashCheck = false;
    private HashUtil util = null;
    private int hashLen = 0;
    private byte[] hashBytes;
    private int hashBytesRet = 0;
    private long size = 0L;
    private FileInputStream fs = null;

    public HashedFileInputStream(File file, boolean hashCheck, HashUtil hashutil, long size) throws FileNotFoundException {
        super(size);
        if (!file.canRead()) {
            throw new FileNotFoundException("can not read from " + file.getName());
        }
        this.util = hashutil;
        this.fs = new FileInputStream(file);
        this.hashCheck = hashCheck;
        this.size = size;
        this.hashLen = this.util.getHashLen();
    }

    protected int processByte() {
        throw new UnsupportedOperationException("do not read byte by byte");
    }

    protected void processBytes(byte[] bytes, int offset, int length) {
        if (this.hashCheck) {
            int read = -1;
            do {
                int segment = length > 4096 ? 4096 : length;
                byte[] buffer = new byte[segment];
                try {
                    read = this.fs.read(buffer, 0, segment);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (read == -1) {
                    String hashString = this.util.calculateHash();
                    try {
                        this.hashBytes = hashString.getBytes("UTF-8");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.hashBytes = hashString.getBytes();
                    }
                    break;
                }
                System.arraycopy(buffer, 0, bytes, offset, read);
                this.util.update(buffer, 0, read);
                offset += read;
            } while ((length -= read) > 0);
            if (length > 0) {
                int hashToGive = this.hashLen - this.hashBytesRet;
                int segment = length > hashToGive ? hashToGive : length;
                System.arraycopy(this.hashBytes, 0, bytes, offset, segment);
                this.hashBytesRet += segment;
            }
        }
    }

    public long getSize() {
        return this.size;
    }
}

