/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.service;

import com.intel.cosbench.api.auth.AuthAPI;
import com.intel.cosbench.api.auth.AuthAPIService;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.StorageAPI;
import com.intel.cosbench.api.storage.StorageAPIService;
import com.intel.cosbench.config.Auth;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.Mission;
import com.intel.cosbench.config.MissionResolver;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Storage;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.config.common.KVConfigParser;
import com.intel.cosbench.driver.agent.Agent;
import com.intel.cosbench.driver.agent.Agents;
import com.intel.cosbench.driver.model.MissionContext;
import com.intel.cosbench.driver.model.OperatorContext;
import com.intel.cosbench.driver.model.OperatorRegistry;
import com.intel.cosbench.driver.model.WorkerContext;
import com.intel.cosbench.driver.model.WorkerRegistry;
import com.intel.cosbench.driver.operator.Operators;
import com.intel.cosbench.driver.service.MissionException;
import com.intel.cosbench.driver.util.OperationPicker;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.LogManager;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.MissionState;
import com.intel.cosbench.service.AbortedException;
import com.intel.cosbench.service.IllegalStateException;
import com.intel.cosbench.service.TimeoutException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

class MissionHandler {
    private static final String AUTH_RETRY_KEY = "retry";
    private static final int DEFAULT_AUTH_RETRY = 0;
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private static final File LOG_DIR = new File(new File("log"), "mission");
    private int retry;
    private Config authConfig;
    private Config storageConfig;
    private AuthAPIService authAPIs;
    private StorageAPIService storageAPIs;
    private ExecutorService executor;
    private MissionContext missionContext;

    static {
        if (!LOG_DIR.exists()) {
            LOG_DIR.mkdirs();
        }
    }

    public MissionContext getMissionContext() {
        return this.missionContext;
    }

    public void setMissionContext(MissionContext missionContext) {
        this.missionContext = missionContext;
    }

    public void setAuthAPIs(AuthAPIService authAPIs) {
        this.authAPIs = authAPIs;
    }

    public void setStorageAPIs(StorageAPIService storageAPIs) {
        this.storageAPIs = storageAPIs;
    }

    public void dispose() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }

    public void init() {
        this.resolveMission();
        this.openLogger();
        this.createOperators();
        this.initOpPicker();
        this.parseConfigs();
        this.createWorkers();
        this.createExecutor();
    }

    private void resolveMission() {
        XmlConfig config = this.missionContext.getConfig();
        MissionResolver resolver = CastorConfigTools.getMissionResolver();
        this.missionContext.setMission(resolver.toMission(config));
    }

    private void openLogger() {
        LogManager manager = LogFactory.createLogManager();
        String name = String.valueOf(this.missionContext.getId()) + ".log";
        try {
            boolean append = false;
            boolean buffer = true;
            manager.setLogFile(LOG_DIR, name, append, buffer);
        }
        catch (IOException e) {
            LOGGER.error("cannot open log file", (Throwable)e);
        }
        LogManager sysManager = LogFactory.getSystemLogManager();
        manager.setLogLevel(sysManager.getLogLevel());
        this.missionContext.setLogManager(manager);
    }

    private void createOperators() {
        OperatorRegistry registry = new OperatorRegistry();
        Mission mission = this.missionContext.getMission();
        this.initOpDefaultName(mission);
        for (Operation op : mission) {
            registry.addOperator(MissionHandler.createOperatorContext(op));
        }
        this.missionContext.setOperatorRegistry(registry);
    }

    private static OperatorContext createOperatorContext(Operation op) {
        OperatorContext context = new OperatorContext();
        Config config = KVConfigParser.parse((String)op.getConfig());
        context.setOperator(Operators.getOperator(op, config));
        return context;
    }

    private void initOpDefaultName(Mission mission) {
        HashSet<String> opTypes = new HashSet<String>();
        for (Operation op : mission.getOperations()) {
            opTypes.add(op.getType());
        }
        if (opTypes.size() == mission.getOperations().size()) {
            return;
        }
        for (String opType : opTypes) {
            int index = 0;
            for (Operation op : mission.getOperations()) {
                if (!op.getType().equals(opType)) continue;
                ++index;
                if (op.getConfig().indexOf("name") >= 0) continue;
                op.setConfig(StringUtils.join((Object[])new Object[]{op.getConfig(), ";name=", String.valueOf(index), "-", op.getType()}));
            }
        }
    }

    private void initOpPicker() {
        OperationPicker picker = new OperationPicker();
        Mission mission = this.missionContext.getMission();
        for (Operation op : mission) {
            picker.addOperation(op.getId(), op.getRatio());
        }
        this.missionContext.setOperationPicker(picker);
    }

    private void parseConfigs() {
        Mission m = this.missionContext.getMission();
        this.authConfig = KVConfigParser.parse((String)m.getAuth().getConfig());
        this.retry = this.authConfig.getInt(AUTH_RETRY_KEY, 0);
        this.storageConfig = KVConfigParser.parse((String)m.getStorage().getConfig());
        LOGGER.debug("driver mission config  is: " + m.getConfig());
    }

    private void createWorkers() {
        WorkerRegistry registry = new WorkerRegistry();
        Mission mission = this.missionContext.getMission();
        int workers = mission.getWorkers();
        int offset = mission.getOffset();
        int idx = 1;
        while (idx <= workers) {
            registry.addWorker(this.createWorkerContext(idx + offset, mission));
            ++idx;
        }
        this.missionContext.setWorkerRegistry(registry);
    }

    private WorkerContext createWorkerContext(int idx, Mission mission) {
        LogManager manager = this.missionContext.getLogManager();
        WorkerContext context = new WorkerContext();
        context.setIndex(idx);
        context.setMission(mission);
        context.setLogger(manager.getLogger());
        context.setErrorStatistics(this.missionContext.getErrorStatistics());
        context.setAuthApi(this.createAuthApi(mission.getAuth(), manager));
        context.setStorageApi(this.createStorageApi(mission.getStorage(), manager));
        return context;
    }

    private AuthAPI createAuthApi(Auth auth, LogManager manager) {
        String type = auth.getType();
        Logger logger = manager.getLogger();
        return this.authAPIs.getAuth(type, this.authConfig, logger);
    }

    private StorageAPI createStorageApi(Storage storage, LogManager manager) {
        String type = storage.getType();
        Logger logger = manager.getLogger();
        return this.storageAPIs.getStorage(type, this.storageConfig, logger);
    }

    private void createExecutor() {
        Mission mission = this.missionContext.getMission();
        int workers = mission.getWorkers();
        this.executor = Executors.newFixedThreadPool(workers);
    }

    public void login() {
        if (!this.missionContext.getState().equals((Object)MissionState.SUBMITTED)) {
            throw new IllegalStateException("mission should be in the state of submitted but " + this.missionContext.getState().name());
        }
        String id = this.missionContext.getId();
        LOGGER.debug("begin to auth mission {}", (Object)id);
        try {
            this.performLogin();
        }
        catch (AbortedException abortedException) {
            this.abortAgents(true);
            this.missionContext.setState(MissionState.ABORTED);
            return;
        }
        catch (MissionException missionException) {
            this.missionContext.setState(MissionState.TERMINATED);
            LOGGER.info("mission {} has been terminated", (Object)id);
            return;
        }
        catch (Exception e) {
            this.missionContext.setState(MissionState.TERMINATED);
            LOGGER.error("unexpected exception", (Throwable)e);
            LOGGER.info("mission {} has been terminated", (Object)id);
            return;
        }
        LOGGER.info("mission {} has been authed successfully", (Object)id);
    }

    private void performLogin() {
        this.missionContext.setState(MissionState.AUTHING);
        List<Agent> agents = this.createAuthAgents();
        this.executeAgents(agents, 0);
        this.missionContext.setState(MissionState.AUTHED);
    }

    private void setAllWorkersAuthContext(AuthContext authContext) {
        Iterator iterator = this.missionContext.getWorkerRegistry().iterator();
        while (iterator.hasNext()) {
            WorkerContext workerContext = (WorkerContext)iterator.next();
            workerContext.getStorageApi().setAuthContext(authContext);
        }
    }

    private List<Agent> createAuthAgentFromContext(WorkerContext workerContext) {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        agents.add(Agents.newAuthAgent(this.retry, workerContext));
        return agents;
    }

    private List<Agent> createAuthAgents() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        Iterator iterator = this.missionContext.getWorkerRegistry().iterator();
        while (iterator.hasNext()) {
            WorkerContext workerContext = (WorkerContext)iterator.next();
            agents.add(Agents.newAuthAgent(this.retry, workerContext));
        }
        return agents;
    }

    public void stress() {
        if (!this.missionContext.getState().equals((Object)MissionState.AUTHED)) {
            throw new IllegalStateException("mission should be in the state of authed");
        }
        String id = this.missionContext.getId();
        LOGGER.debug("begin to execute mission {}", (Object)id);
        try {
            this.stressTarget();
        }
        catch (TimeoutException timeoutException) {
            boolean shutdownNow = false;
            this.abortAgents(shutdownNow);
            return;
        }
        catch (AbortedException abortedException) {
            boolean shutdownNow = true;
            this.abortAgents(shutdownNow);
            this.missionContext.setState(MissionState.ABORTED);
            return;
        }
        catch (MissionException missionException) {
            this.missionContext.setState(MissionState.TERMINATED);
            LOGGER.info("mission {} has been terminated", (Object)id);
            return;
        }
        catch (Exception e) {
            this.missionContext.setState(MissionState.TERMINATED);
            LOGGER.error("unexpected exception", (Throwable)e);
            LOGGER.info("mission {} has been terminated", (Object)id);
            return;
        }
        LOGGER.info("mission {} has been executed successfully", (Object)id);
    }

    private void stressTarget() {
        this.missionContext.setState(MissionState.LAUNCHED);
        List<Agent> agents = this.createWorkAgents();
        Mission m = this.missionContext.getMission();
        int timeout = m.getRampup() + m.getRuntime() + m.getRampdown();
        this.executeAgents(agents, timeout == 0 ? 0 : timeout + 60);
        this.missionContext.setState(MissionState.FINISHED);
        this.missionContext.getErrorStatistics().summaryToMission(this.missionContext.getLogManager().getLogger());
    }

    private List<Agent> createWorkAgents() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        Iterator iterator = this.missionContext.getWorkerRegistry().iterator();
        while (iterator.hasNext()) {
            WorkerContext workerConext = (WorkerContext)iterator.next();
            agents.add(Agents.newWorkAgent(workerConext, this.missionContext));
        }
        return agents;
    }

    private void executeAgents(List<Agent> agents, int timeout) {
        int num = agents.size();
        LOGGER.debug("begin to execute agents, {} in total", (Object)num);
        try {
            if (timeout == 0) {
                this.executor.invokeAll(agents);
            } else {
                List futures = this.executor.invokeAll(agents, timeout, TimeUnit.SECONDS);
                for (Future future : futures) {
                    if (!future.isCancelled()) continue;
                    throw new TimeoutException();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new AbortedException();
        }
        LOGGER.debug("all {} agents have finished execution", (Object)num);
        ArrayList<Integer> errIds = new ArrayList<Integer>();
        Iterator iterator = this.missionContext.getWorkerRegistry().iterator();
        while (iterator.hasNext()) {
            WorkerContext worker = (WorkerContext)iterator.next();
            if (!worker.isError() && !worker.isAborted()) continue;
            errIds.add(worker.getIndex());
        }
        if (errIds.isEmpty()) {
            return;
        }
        LOGGER.error("detected workers {} have encountered errors", errIds);
        throw new MissionException();
    }

    public void close() {
        if (!this.missionContext.getState().equals((Object)MissionState.FINISHED)) {
            throw new IllegalStateException("mission should be in the state of finished");
        }
        String id = this.missionContext.getId();
        this.missionContext.setState(MissionState.ACCOMPLISHED);
        int i = 0;
        while (i < this.missionContext.getReport().getAllMetrics().length) {
            LOGGER.debug("!!!! mission op: " + this.missionContext.getReport().getAllMetrics()[i].getOpType() + "-" + this.missionContext.getReport().getAllMetrics()[i].getOpType());
            if (this.missionContext.getReport().getAllMetrics()[i].getSampleCount() == 0 && this.missionContext.getReport().getAllMetrics()[i].getTotalSampleCount() > 0) {
                this.missionContext.setState(MissionState.FAILED);
                LOGGER.debug("!!!! mission opt -> FAILED");
                break;
            }
            ++i;
        }
        LOGGER.info("mission {} has been closed successfully", (Object)id);
    }

    public void abort() {
        String id = this.missionContext.getId();
        Future<?> future = this.missionContext.getFuture();
        if (future != null) {
            if (future.isCancelled()) {
                return;
            }
            if (future.cancel(true)) {
                return;
            }
        }
        if (MissionState.isStopped((MissionState)this.missionContext.getState())) {
            LOGGER.warn("mission {} not aborted as it is already stopped", (Object)id);
            return;
        }
        this.missionContext.setState(MissionState.ABORTED);
        LOGGER.info("mission {} has been aborted successfully", (Object)id);
    }

    private void abortAgents(boolean shutdownNow) {
        Thread.interrupted();
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                String id = this.missionContext.getId();
                if (!(this.awaitTermination(5) || this.awaitTermination(10) || this.awaitTermination(30))) {
                    LOGGER.warn("fail to abort agents for mission {}", (Object)id);
                } else {
                    LOGGER.info("all agents have been aborted in mission {}", (Object)id);
                }
                LOGGER.info("mission {} appears to be aborted", (Object)id);
            }
        }
        catch (InterruptedException interruptedException) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private boolean awaitTermination(int seconds) {
        try {
            if (!this.executor.isTerminated()) {
                LOGGER.info("wait {} seconds for agents to abort ...", (Object)seconds);
                this.executor.awaitTermination(seconds, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.debug("get aborted when aborting mission");
        }
        return this.executor.isTerminated();
    }
}

