/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.service;

import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageAPI;
import com.intel.cosbench.api.storage.StorageAPIFactory;
import com.intel.cosbench.api.storage.StorageAPIService;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.util.List;

public class COSBStorageAPIService
implements StorageAPIService {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private List<StorageAPIFactory> factories;

    public void setFactories(List<StorageAPIFactory> factories) {
        this.factories = factories;
        StringBuilder buffer = new StringBuilder();
        for (StorageAPIFactory factory : factories) {
            buffer.append(factory.getStorageName()).append(", ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        LOGGER.info("detected supported storage types: {}", (Object)buffer);
    }

    public StorageAPI getStorage(String type, Config config, Logger logger) {
        StorageAPI storage = this.createStorage(type);
        storage.init(config, logger);
        return storage;
    }

    private StorageAPI createStorage(String type) {
        if ("none".equals(type)) {
            return new NoneStorage();
        }
        for (StorageAPIFactory factory : this.factories) {
            if (!factory.getStorageName().equals(type)) continue;
            return factory.getStorageAPI();
        }
        String msg = "unrecognized storage type: " + type;
        throw new ConfigException(msg);
    }
}

