/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.service;

import com.intel.cosbench.api.auth.AuthAPIService;
import com.intel.cosbench.api.storage.StorageAPIService;
import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.driver.model.DriverContext;
import com.intel.cosbench.driver.service.COSBDriverService;
import com.intel.cosbench.service.AbstractServiceFactory;
import com.intel.cosbench.service.DriverService;
import com.intel.cosbench.service.DriverServiceFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.lang.SystemUtils;

public class COSBDriverServiceFactory
extends AbstractServiceFactory
implements DriverServiceFactory {
    private static final String SERVICE_NAME = "driver";
    private static final String CFG_FILE_KEY = "cosbench.driver.config";
    private static final String UNIX_DEFAULT_CFG_FILE = "/etc/cosbench/driver.conf";
    private static final String WIN_DEFAULT_CFG_FILE = "C:\\driver.conf";
    private AuthAPIService authAPIs;
    private StorageAPIService storageAPIs;

    public COSBDriverServiceFactory() {
        CastorConfigTools.getMissionResolver();
    }

    public void setAuthAPIs(AuthAPIService authAPIs) {
        this.authAPIs = authAPIs;
    }

    public void setStorageAPIs(StorageAPIService storageAPIs) {
        this.storageAPIs = storageAPIs;
    }

    protected String getConfigFile() {
        String configFile = System.getProperty(CFG_FILE_KEY);
        if (configFile != null) {
            return configFile;
        }
        if (new File("driver.conf").exists()) {
            return "driver.conf";
        }
        if (new File("conf/driver.conf").exists()) {
            return "conf/driver.conf";
        }
        return SystemUtils.IS_OS_WINDOWS ? WIN_DEFAULT_CFG_FILE : UNIX_DEFAULT_CFG_FILE;
    }

    protected String getServiceName() {
        return SERVICE_NAME;
    }

    public DriverService getDriverService() {
        COSBDriverService service = new COSBDriverService();
        DriverContext context = this.getDriverContext();
        service.setContext(context);
        service.setAuthAPIs(this.authAPIs);
        service.setStorageAPIs(this.storageAPIs);
        service.init();
        return service;
    }

    private DriverContext getDriverContext() {
        DriverContext context = new DriverContext();
        context.setName(this.loadDriverName());
        context.setUrl(this.loadDriverUrl());
        context.setVersion(this.getVersion());
        return context;
    }

    private String getVersion() {
        String str = this.getName("VERSION");
        String str2 = this.getName("BUILD.no");
        return String.valueOf(str) + "." + str2;
    }

    private String getName(String fileName) {
        String str = null;
        File myFile = new File(fileName);
        if (!myFile.exists()) {
            System.err.println("Can't Find " + fileName);
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(myFile));
            str = in.readLine();
            in.close();
        }
        catch (IOException e) {
            e.getStackTrace();
        }
        return str;
    }

    protected String loadLogLevel() {
        return this.config.get("driver.log_level", "INFO");
    }

    protected String loadLogFile() {
        return this.config.get("driver.log_file", "log/system.log");
    }

    private String loadDriverName() {
        return this.config.get("driver.name", "N/A");
    }

    private String loadDriverUrl() {
        return this.config.get("driver.url", "N/A");
    }
}

