/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.service;

import com.intel.cosbench.api.auth.AuthAPIService;
import com.intel.cosbench.api.storage.StorageAPIService;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.driver.model.DriverContext;
import com.intel.cosbench.driver.model.MissionContext;
import com.intel.cosbench.driver.model.MissionListener;
import com.intel.cosbench.driver.repository.MissionRepository;
import com.intel.cosbench.driver.repository.RAMMissionRepository;
import com.intel.cosbench.driver.service.MissionHandler;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.model.MissionInfo;
import com.intel.cosbench.model.MissionState;
import com.intel.cosbench.service.DriverService;
import com.intel.cosbench.service.IllegalStateException;
import com.intel.cosbench.service.UnexpectedException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.math.RandomUtils;

class COSBDriverService
implements DriverService,
MissionListener {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private DriverContext context;
    private Map<String, MissionHandler> handlers;
    private AuthAPIService authAPIs;
    private StorageAPIService storageAPIs;
    private ExecutorService executor;
    private MissionRepository memRepo = new RAMMissionRepository();

    public void setContext(DriverContext context) {
        this.context = context;
    }

    public void setAuthAPIs(AuthAPIService authAPIs) {
        this.authAPIs = authAPIs;
    }

    public void setStorageAPIs(StorageAPIService storageAPIs) {
        this.storageAPIs = storageAPIs;
    }

    public void init() {
        this.handlers = new HashMap<String, MissionHandler>();
        this.handlers = Collections.synchronizedMap(this.handlers);
        this.executor = Executors.newCachedThreadPool();
    }

    public synchronized String submit(XmlConfig config) {
        LOGGER.debug("submitting mission ... ");
        MissionContext mission = COSBDriverService.createMissionContext(config);
        MissionHandler handler = this.createHandler(mission);
        mission.addListener(this);
        this.handlers.put(mission.getId(), handler);
        this.memRepo.saveMission(mission);
        LOGGER.debug("mission {} has been submitted", (Object)mission.getId());
        return mission.getId();
    }

    private static MissionContext createMissionContext(XmlConfig config) {
        MissionContext context = new MissionContext();
        context.setId(COSBDriverService.generateMissionId());
        context.setDate(new Date());
        context.setConfig(config);
        context.setState(MissionState.SUBMITTED);
        return context;
    }

    private static String generateMissionId() {
        String id = "M" + Integer.toHexString(RandomUtils.nextInt((int)16));
        id = String.valueOf(id) + Integer.toHexString(new Date().hashCode());
        id = String.valueOf(id) + Integer.toHexString(RandomUtils.nextInt((int)16));
        return id.toUpperCase();
    }

    private MissionHandler createHandler(MissionContext mission) {
        MissionHandler handler = new MissionHandler();
        handler.setMissionContext(mission);
        handler.setAuthAPIs(this.authAPIs);
        handler.setStorageAPIs(this.storageAPIs);
        handler.init();
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String id) {
        MissionHandler handler = this.handlers.get(id);
        LOGGER.info("handler=" + id);
        if (handler == null) {
            throw new IllegalStateException("no mission handler");
        }
        if (handler.getMissionContext().getFuture() != null) {
            throw new IllegalStateException("mission is busy");
        }
        LOGGER.debug("authing mission {} ...", (Object)id);
        Future<?> future = null;
        MissionHandler missionHandler = handler;
        synchronized (missionHandler) {
            class AuthThread
            implements Runnable {
                private final /* synthetic */ MissionHandler val$handler;

                AuthThread(MissionHandler missionHandler) {
                    this.val$handler = missionHandler;
                }

                @Override
                public void run() {
                    this.val$handler.login();
                    this.val$handler.getMissionContext().setFuture(null);
                }
            }
            future = this.executor.submit(new AuthThread(handler));
            handler.getMissionContext().setFuture(future);
        }
        LOGGER.debug("mission {} has been requested to auth", (Object)id);
        COSBDriverService.yieldExecution(200);
        COSBDriverService.awaitTermination(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(String id) {
        MissionHandler handler = this.handlers.get(id);
        if (handler == null) {
            throw new IllegalStateException("no mission handler");
        }
        if (handler.getMissionContext().getFuture() != null) {
            throw new IllegalStateException("mission is busy");
        }
        LOGGER.debug("launching mission {} ...", (Object)id);
        Future<?> future = null;
        MissionHandler missionHandler = handler;
        synchronized (missionHandler) {
            class DriverThread
            implements Runnable {
                private final /* synthetic */ MissionHandler val$handler;

                DriverThread(MissionHandler missionHandler) {
                    this.val$handler = missionHandler;
                }

                @Override
                public void run() {
                    this.val$handler.stress();
                    this.val$handler.getMissionContext().setFuture(null);
                }
            }
            future = this.executor.submit(new DriverThread(handler));
            handler.getMissionContext().setFuture(future);
        }
        LOGGER.debug("mission {} has been requested to launch", (Object)id);
        COSBDriverService.yieldExecution(200);
    }

    public void close(String id) {
        MissionHandler handler = this.handlers.get(id);
        if (handler == null) {
            throw new IllegalStateException("no mission handler");
        }
        LOGGER.debug("closing mission {} ... ", (Object)id);
        handler.close();
        LOGGER.debug("mission {} has been closed", (Object)id);
    }

    public void abort(String id) {
        MissionHandler handler = this.handlers.get(id);
        if (handler == null) {
            return;
        }
        LOGGER.debug("aborting mission {} ... ", (Object)id);
        handler.abort();
        COSBDriverService.yieldExecution(200);
        LOGGER.debug("mission {} has been requested to abort", (Object)id);
    }

    private static void yieldExecution(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static void awaitTermination(Future<?> future) {
        try {
            if (future != null) {
                future.get();
            }
        }
        catch (CancellationException ce) {
            LOGGER.warn("task has been cancelled!", (Throwable)ce);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ee) {
            LOGGER.error("unexcepted exception", (Throwable)ee);
            throw new UnexpectedException((Throwable)ee);
        }
    }

    public DriverInfo getDriverInfo() {
        return this.context;
    }

    public MissionInfo getMissionInfo(String id) {
        return this.memRepo.getMission(id);
    }

    public MissionInfo[] getActiveMissions() {
        return this.memRepo.getActiveMissions();
    }

    public MissionInfo[] getHistoryMissions() {
        return this.memRepo.getInactiveMissions();
    }

    @Override
    public void missionStopped(MissionContext mission) {
        String id = mission.getId();
        MissionHandler handler = this.handlers.remove(id);
        handler.dispose();
        LOGGER.debug("handler for mission {} has been detached", (Object)id);
    }
}

