/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.service;

import com.intel.cosbench.api.auth.AuthAPI;
import com.intel.cosbench.api.auth.AuthAPIFactory;
import com.intel.cosbench.api.auth.AuthAPIService;
import com.intel.cosbench.api.auth.NoneAuth;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.util.List;

public class COSBAuthAPIService
implements AuthAPIService {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private List<AuthAPIFactory> factories;

    public void setFactories(List<AuthAPIFactory> factories) {
        this.factories = factories;
        StringBuilder buffer = new StringBuilder();
        for (AuthAPIFactory factory : factories) {
            buffer.append(factory.getAuthName()).append(", ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        LOGGER.info("detected supported auth types: {}", (Object)buffer);
    }

    public AuthAPI getAuth(String type, Config config, Logger logger) {
        AuthAPI auth = this.createAuth(type);
        auth.init(config, logger);
        return auth;
    }

    private AuthAPI createAuth(String type) {
        if ("none".equals(type)) {
            return new NoneAuth();
        }
        for (AuthAPIFactory factory : this.factories) {
            if (!factory.getAuthName().equals(type)) continue;
            return factory.getAuthAPI();
        }
        String msg = "unrecognized auth type: " + type;
        throw new ConfigException(msg);
    }
}

