/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.repository;

import com.intel.cosbench.driver.model.MissionContext;
import com.intel.cosbench.driver.repository.MissionList;
import com.intel.cosbench.model.MissionState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class SimpleMissionList
implements MissionList {
    private int maxCapacity;
    private int capacity = 0;
    private Map<String, MissionContext> list;
    private List<MissionContext> toBeRemoved;

    public SimpleMissionList(int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.list = new LinkedHashMap<String, MissionContext>(maxCapacity);
        this.toBeRemoved = new ArrayList<MissionContext>();
    }

    @Override
    public int count() {
        return this.list.size();
    }

    @Override
    public MissionContext fetch(String id) {
        return this.list.get(id);
    }

    @Override
    public MissionContext[] add(MissionContext mission) {
        this.toBeRemoved.clear();
        this.list.put(mission.getId(), mission);
        ++this.capacity;
        this.shrinkListSize();
        MissionContext[] result = new MissionContext[this.toBeRemoved.size()];
        result = this.toBeRemoved.toArray(result);
        this.toBeRemoved.clear();
        return result;
    }

    private void shrinkListSize() {
        Iterator<MissionContext> iter = this.list.values().iterator();
        while (this.capacity > this.maxCapacity && iter.hasNext()) {
            this.tryRemoveMissions(iter);
        }
    }

    private void tryRemoveMissions(Iterator<MissionContext> iter) {
        MissionContext mission = iter.next();
        if (!MissionState.isStopped((MissionState)mission.getState())) {
            return;
        }
        iter.remove();
        --this.capacity;
        this.toBeRemoved.add(mission);
    }

    @Override
    public Collection<MissionContext> values() {
        return this.list.values();
    }
}

