/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.repository;

import com.intel.cosbench.driver.model.MissionContext;
import com.intel.cosbench.driver.model.MissionListener;
import com.intel.cosbench.driver.repository.MissionList;
import com.intel.cosbench.driver.repository.MissionRepository;
import com.intel.cosbench.driver.repository.SimpleMissionList;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.MissionState;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class RAMMissionRepository
implements MissionRepository,
MissionListener {
    private static final int MAX_MISSION_DEFAULT = 100;
    private static final String MAX_MISSION_KEY = "cosbench.driver.history";
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private MissionList missions;

    public RAMMissionRepository() {
        SimpleMissionList missions = new SimpleMissionList(this.getMaxCapacity());
        this.missions = missions;
    }

    private int getMaxCapacity() {
        int maxCapacity = 100;
        String config = System.getProperty(MAX_MISSION_KEY);
        if (!StringUtils.isEmpty((String)config)) {
            try {
                maxCapacity = Integer.parseInt(config);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        LOGGER.debug("will hold {} missions in RAM", (Object)maxCapacity);
        return maxCapacity;
    }

    @Override
    public synchronized int getSize() {
        return this.missions.count();
    }

    @Override
    public synchronized void saveMission(MissionContext mission) {
        mission.addListener(this);
        MissionContext[] removed = this.missions.add(mission);
        LOGGER.debug("mission {} has been saved in RAM", (Object)mission.getId());
        LOGGER.debug("{} missions have been removed from RAM", (Object)removed.length);
    }

    @Override
    public synchronized MissionContext getMission(String id) {
        return this.missions.fetch(id);
    }

    @Override
    public synchronized MissionContext[] getAllMissions() {
        int size = this.missions.count();
        return this.missions.values().toArray(new MissionContext[size]);
    }

    @Override
    public synchronized MissionContext[] getActiveMissions() {
        ArrayList<MissionContext> result = new ArrayList<MissionContext>();
        for (MissionContext mission : this.missions.values()) {
            if (MissionState.isStopped((MissionState)mission.getState())) continue;
            result.add(mission);
        }
        return result.toArray(new MissionContext[result.size()]);
    }

    @Override
    public synchronized MissionContext[] getInactiveMissions() {
        ArrayList<MissionContext> result = new ArrayList<MissionContext>();
        for (MissionContext mission : this.missions.values()) {
            if (!MissionState.isStopped((MissionState)mission.getState())) continue;
            result.add(mission);
        }
        return result.toArray(new MissionContext[result.size()]);
    }

    @Override
    public void missionStopped(MissionContext mission) {
        mission.disposeRuntime();
        LOGGER.debug("mission {} has been disposed", (Object)mission.getId());
    }
}

