/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.operator;

import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.bench.Result;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.driver.generator.RandomInputStream;
import com.intel.cosbench.driver.generator.XferCountingInputStream;
import com.intel.cosbench.driver.operator.AbstractOperator;
import com.intel.cosbench.driver.operator.Operator;
import com.intel.cosbench.driver.operator.Session;
import com.intel.cosbench.driver.util.ObjectPicker;
import com.intel.cosbench.driver.util.SizePicker;
import com.intel.cosbench.service.AbortedException;
import java.io.InputStream;
import java.util.Date;
import java.util.Random;
import org.apache.commons.io.IOUtils;

class Writer
extends AbstractOperator {
    public static final String OP_TYPE = "write";
    private boolean chunked;
    private boolean isRandom;
    private boolean hashCheck = false;
    private ObjectPicker objPicker = new ObjectPicker();
    private SizePicker sizePicker = new SizePicker();

    @Override
    protected void init(String id, int ratio, String division, Config config) {
        super.init(id, ratio, division, config);
        this.objPicker.init(division, config);
        this.sizePicker.init(config);
        this.chunked = config.getBoolean("chunked", false);
        this.isRandom = !config.get("content", "random").equals("zero");
        this.hashCheck = config.getBoolean("hashCheck", false);
    }

    @Override
    public String getOpType() {
        return OP_TYPE;
    }

    @Override
    protected void operate(int idx, int all, Session session) {
        Random random = session.getRandom();
        long size = this.sizePicker.pickObjSize(random);
        long len = this.chunked ? -1L : size;
        String[] path = this.objPicker.pickObjPath(random, idx, all);
        RandomInputStream in = new RandomInputStream(size, random, this.isRandom, this.hashCheck);
        Sample sample = Writer.doWrite((InputStream)((Object)in), len, path[0], path[1], this.config, session, this);
        session.getListener().onSampleCreated(sample);
        Date now = sample.getTimestamp();
        Result result = new Result(now, this.getId(), this.getOpType(), this.getSampleType(), this.getName(), sample.isSucc());
        session.getListener().onOperationCompleted(result);
    }

    public static Sample doWrite(InputStream in, long length, String conName, String objName, Config config, Session session, Operator op) {
        if (Thread.interrupted()) {
            throw new AbortedException();
        }
        XferCountingInputStream cin = new XferCountingInputStream(in);
        long start = System.currentTimeMillis();
        try {
            try {
                session.getApi().createObject(conName, objName, (InputStream)((Object)cin), length, config);
            }
            catch (StorageInterruptedException sie) {
                Writer.doLogErr(session.getLogger(), sie.getMessage(), (Exception)((Object)sie));
                throw new AbortedException();
            }
            catch (Exception e) {
                Writer.isUnauthorizedException(e, session);
                Writer.errorStatisticsHandle(e, session, String.valueOf(conName) + "/" + objName);
                Sample sample = new Sample(new Date(), op.getId(), op.getOpType(), op.getSampleType(), op.getName(), false);
                IOUtils.closeQuietly((InputStream)((Object)cin));
                return sample;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((Object)cin));
        }
        long end = System.currentTimeMillis();
        Date now = new Date(end);
        return new Sample(now, op.getId(), op.getOpType(), op.getSampleType(), op.getName(), true, end - start, cin.getXferTime(), cin.getByteCount());
    }
}

