/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.operator;

import com.intel.cosbench.api.auth.AuthException;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.bench.Result;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.driver.agent.AgentException;
import com.intel.cosbench.driver.generator.RandomInputStream;
import com.intel.cosbench.driver.operator.AbstractOperator;
import com.intel.cosbench.driver.operator.Session;
import com.intel.cosbench.driver.operator.Writer;
import com.intel.cosbench.driver.util.ObjectScanner;
import com.intel.cosbench.driver.util.SizePicker;
import com.intel.cosbench.service.AbortedException;
import java.io.InputStream;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

class Preparer
extends AbstractOperator {
    public static final String OP_TYPE = "prepare";
    private boolean chunked;
    private boolean isRandom;
    private boolean createContainer;
    private boolean hashCheck = false;
    private ObjectScanner objScanner = new ObjectScanner();
    private SizePicker sizePicker = new SizePicker();

    @Override
    protected void init(String id, int ratio, String division, Config config) {
        super.init(id, ratio, division, config);
        this.objScanner.init(division, config);
        this.sizePicker.init(config);
        this.chunked = config.getBoolean("chunked", false);
        this.isRandom = !config.get("content", "random").equals("zero");
        this.createContainer = config.getBoolean("createContainer", true);
        this.hashCheck = config.getBoolean("hashCheck", false);
    }

    @Override
    public String getOpType() {
        return OP_TYPE;
    }

    @Override
    public String getSampleType() {
        return "write";
    }

    @Override
    protected void operate(int idx, int all, Session session) {
        String[] path = null;
        String opTye = this.getOpType();
        String lastContainer = null;
        while ((path = this.objScanner.nextObjPath(path, idx, all)) != null) {
            if (this.createContainer && !StringUtils.equals(lastContainer, (String)path[0])) {
                Preparer.doInit(path[0], this.config, session);
                lastContainer = path[0];
            }
            if (path[1] == null) continue;
            Random random = session.getRandom();
            long size = this.sizePicker.pickObjSize(random);
            long len = this.chunked ? -1L : size;
            RandomInputStream in = new RandomInputStream(size, random, this.isRandom, this.hashCheck);
            Sample sample = Writer.doWrite((InputStream)((Object)in), len, path[0], path[1], this.config, session, this);
            sample.setOpType(opTye);
            session.getListener().onSampleCreated(sample);
        }
        Date now = new Date();
        Result result = new Result(now, this.getId(), this.getOpType(), this.getSampleType(), this.getName(), true);
        session.getListener().onOperationCompleted(result);
    }

    public static void doInit(String conName, Config config, Session session) {
        if (Thread.interrupted()) {
            throw new AbortedException();
        }
        try {
            session.getApi().createContainer(conName, config);
        }
        catch (StorageInterruptedException sie) {
            Preparer.doLogErr(session.getLogger(), sie.getMessage(), (Exception)((Object)sie));
            throw new AbortedException();
        }
        catch (StorageException se) {
            Preparer.isUnauthorizedException((Exception)((Object)se), session);
            Preparer.errorStatisticsHandle((Exception)((Object)se), session, conName);
            if (session.getApi().isAuthValid().booleanValue()) {
                throw new AgentException();
            }
            throw new AuthException((Throwable)se);
        }
        catch (Exception exception) {
            throw new AgentException();
        }
    }
}

