/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.operator;

import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.driver.operator.AbstractOperator;
import com.intel.cosbench.driver.operator.Cleaner;
import com.intel.cosbench.driver.operator.Deleter;
import com.intel.cosbench.driver.operator.Disposer;
import com.intel.cosbench.driver.operator.FileWriter;
import com.intel.cosbench.driver.operator.Initializer;
import com.intel.cosbench.driver.operator.Lister;
import com.intel.cosbench.driver.operator.Operator;
import com.intel.cosbench.driver.operator.Preparer;
import com.intel.cosbench.driver.operator.Reader;
import com.intel.cosbench.driver.operator.Writer;
import org.apache.commons.lang.StringUtils;

public class Operators {
    public static Operator getOperator(Operation op, Config config) {
        AbstractOperator operator = Operators.createOperator(op.getType());
        operator.init(op.getId(), op.getRatio(), op.getDivision(), config);
        return operator;
    }

    private static AbstractOperator createOperator(String type) {
        if (StringUtils.equals((String)type, (String)"read")) {
            return new Reader();
        }
        if (StringUtils.equals((String)type, (String)"write")) {
            return new Writer();
        }
        if (StringUtils.equals((String)type, (String)"list")) {
            return new Lister();
        }
        if (StringUtils.equals((String)type, (String)"filewrite")) {
            return new FileWriter();
        }
        if (StringUtils.equals((String)type, (String)"prepare")) {
            return new Preparer();
        }
        if (StringUtils.equals((String)type, (String)"cleanup")) {
            return new Cleaner();
        }
        if (StringUtils.equals((String)type, (String)"init")) {
            return new Initializer();
        }
        if (StringUtils.equals((String)type, (String)"dispose")) {
            return new Disposer();
        }
        if (StringUtils.equals((String)type, (String)"delete")) {
            return new Deleter();
        }
        String msg = "unrecognized operation: " + type;
        throw new ConfigException(msg);
    }
}

