/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.operator;

import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.bench.Result;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.driver.operator.AbstractOperator;
import com.intel.cosbench.driver.operator.Session;
import com.intel.cosbench.driver.util.ObjectPicker;
import com.intel.cosbench.service.AbortedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;

public class Lister
extends AbstractOperator {
    public static final String OP_TYPE = "list";
    private ObjectPicker objPicker = new ObjectPicker();
    private byte[] buffer = new byte[0x100000];

    @Override
    protected void init(String id, int ratio, String division, Config config) {
        super.init(id, ratio, division, config);
        this.objPicker.init4Lister(division, config);
    }

    @Override
    public String getOpType() {
        return OP_TYPE;
    }

    @Override
    protected void operate(int idx, int all, Session session) {
        String[] path = this.objPicker.pickTargetPath(session.getRandom(), idx, all);
        NullOutputStream out = new NullOutputStream();
        Sample sample = this.doList((OutputStream)out, path[0], path[1], this.config, session);
        session.getListener().onSampleCreated(sample);
        Date now = sample.getTimestamp();
        Result result = new Result(now, this.getId(), this.getOpType(), this.getSampleType(), this.getName(), sample.isSucc());
        session.getListener().onOperationCompleted(result);
    }

    private Sample doList(OutputStream out, String conName, String objName, Config config, Session session) {
        if (Thread.interrupted()) {
            throw new AbortedException();
        }
        InputStream in = null;
        CountingOutputStream cout = new CountingOutputStream(out);
        Lister.doLogWarn(session.getLogger(), "listerrr: " + conName + "/" + objName);
        long start = System.currentTimeMillis();
        long xferTime = 0L;
        try {
            try {
                Lister.doLogDebug(session.getLogger(), "worker " + session.getIndex() + " List target " + conName + "/" + objName);
                in = session.getApi().getList(conName, objName, config);
                long xferStart = System.currentTimeMillis();
                this.copyLarge(in, (OutputStream)cout);
                xferTime = System.currentTimeMillis() - xferStart;
            }
            catch (StorageInterruptedException sie) {
                Lister.doLogErr(session.getLogger(), sie.getMessage(), (Exception)((Object)sie));
                throw new AbortedException();
            }
            catch (Exception e) {
                Lister.isUnauthorizedException(e, session);
                Lister.errorStatisticsHandle(e, session, String.valueOf(conName) + "/" + objName);
                Sample sample = new Sample(new Date(), this.getId(), this.getOpType(), this.getSampleType(), this.getName(), false);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)cout);
                return sample;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly((OutputStream)cout);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)cout);
        long end = System.currentTimeMillis();
        Date now = new Date(end);
        return new Sample(now, this.getId(), this.getOpType(), this.getSampleType(), this.getName(), true, end - start, xferTime, cout.getByteCount());
    }

    public OutputStream copyLarge(InputStream input, OutputStream output) throws IOException {
        int n = 0;
        while (-1 != (n = input.read(this.buffer))) {
            output.write(this.buffer, 0, n);
        }
        return output;
    }
}

