/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.operator;

import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.driver.generator.XferCountingInputStream;
import com.intel.cosbench.driver.operator.AbstractOperator;
import com.intel.cosbench.driver.operator.Session;
import com.intel.cosbench.driver.util.ContainerPicker;
import com.intel.cosbench.driver.util.FilePicker;
import com.intel.cosbench.service.AbortedException;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.IOUtils;

class FileWriter
extends AbstractOperator {
    public static final String OP_TYPE = "filewrite";
    private ContainerPicker contPicker = new ContainerPicker();
    private FilePicker filePicker = new FilePicker();
    private File folder;
    private File[] listOfFiles;
    private boolean hashCheck = false;

    @Override
    protected void init(String id, int ratio, String division, Config config) {
        super.init(id, ratio, division, config);
        this.contPicker.init(division, config);
        String filepath = config.get("files");
        this.folder = new File(filepath);
        if (!this.folder.exists()) {
            throw new RuntimeException("Folder " + filepath + " does not exist.");
        }
        this.listOfFiles = this.folder.listFiles();
        Arrays.sort(this.listOfFiles);
        String range = "(1," + this.listOfFiles.length + ")";
        this.filePicker.init(range, config);
        this.hashCheck = config.getBoolean("hashCheck", false);
    }

    @Override
    public String getOpType() {
        return OP_TYPE;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void operate(int idx, int all, Session session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 11[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Sample doWrite(InputStream in, long length, String conName, String objName, Config config, Session session) {
        if (Thread.interrupted()) {
            throw new AbortedException();
        }
        XferCountingInputStream cin = new XferCountingInputStream(in);
        long start = System.currentTimeMillis();
        try {
            try {
                session.getApi().createObject(conName, objName, (InputStream)((Object)cin), length, config);
            }
            catch (StorageInterruptedException sie) {
                FileWriter.doLogErr(session.getLogger(), sie.getMessage(), (Exception)((Object)sie));
                throw new AbortedException();
            }
            catch (Exception e) {
                FileWriter.isUnauthorizedException(e, session);
                FileWriter.doLogErr(session.getLogger(), "fail to perform filewrite operation", e);
                Sample sample = new Sample(new Date(), this.getId(), this.getOpType(), this.getSampleType(), this.getName(), false);
                IOUtils.closeQuietly((InputStream)((Object)cin));
                return sample;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)((Object)cin));
        }
        long end = System.currentTimeMillis();
        Date now = new Date(end);
        return new Sample(now, this.getId(), this.getOpType(), this.getSampleType(), this.getName(), true, end - start, cin.getXferTime(), cin.getByteCount());
    }
}

