/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.operator;

import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.bench.Result;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.driver.operator.AbstractOperator;
import com.intel.cosbench.driver.operator.Operator;
import com.intel.cosbench.driver.operator.Session;
import com.intel.cosbench.driver.util.ObjectPicker;
import com.intel.cosbench.service.AbortedException;
import java.util.Date;

class Deleter
extends AbstractOperator {
    public static final String OP_TYPE = "delete";
    private ObjectPicker objPicker = new ObjectPicker();

    @Override
    protected void init(String id, int ratio, String division, Config config) {
        super.init(id, ratio, division, config);
        this.objPicker.init(division, config);
    }

    @Override
    public String getOpType() {
        return OP_TYPE;
    }

    @Override
    protected void operate(int idx, int all, Session session) {
        String[] path = this.objPicker.pickObjPath(session.getRandom(), idx, all);
        Sample sample = Deleter.doDelete(path[0], path[1], this.config, session, this);
        session.getListener().onSampleCreated(sample);
        Date now = sample.getTimestamp();
        Result result = new Result(now, this.getId(), this.getOpType(), this.getSampleType(), this.getName(), sample.isSucc());
        session.getListener().onOperationCompleted(result);
    }

    public static Sample doDelete(String conName, String objName, Config config, Session session, Operator op) {
        if (Thread.interrupted()) {
            throw new AbortedException();
        }
        long start = System.currentTimeMillis();
        try {
            session.getApi().deleteObject(conName, objName, config);
        }
        catch (StorageInterruptedException sie) {
            Deleter.doLogErr(session.getLogger(), sie.getMessage(), (Exception)((Object)sie));
            throw new AbortedException();
        }
        catch (StorageException storageException) {
            String msg = "Error deleting object " + conName + ": " + objName;
            Deleter.doLogWarn(session.getLogger(), msg);
        }
        catch (Exception e) {
            Deleter.isUnauthorizedException(e, session);
            Deleter.errorStatisticsHandle(e, session, String.valueOf(conName) + "/" + objName);
            return new Sample(new Date(), op.getId(), op.getOpType(), op.getSampleType(), op.getName(), false);
        }
        long end = System.currentTimeMillis();
        Date now = new Date(end);
        return new Sample(now, op.getId(), op.getOpType(), op.getSampleType(), op.getName(), true, end - start, 0L, 0L);
    }
}

