/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.operator;

import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.bench.Result;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.driver.agent.AgentException;
import com.intel.cosbench.driver.operator.AbstractOperator;
import com.intel.cosbench.driver.operator.Deleter;
import com.intel.cosbench.driver.operator.Session;
import com.intel.cosbench.driver.util.ObjectScanner;
import com.intel.cosbench.service.AbortedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

class Cleaner
extends AbstractOperator {
    public static final String OP_TYPE = "cleanup";
    private boolean deleteContainer;
    private ObjectScanner objScanner = new ObjectScanner();

    @Override
    protected void init(String id, int ratio, String division, Config config) {
        super.init(id, ratio, division, config);
        this.objScanner.init(division, config);
        this.deleteContainer = config.getBoolean("deleteContainer", true);
    }

    @Override
    public String getOpType() {
        return OP_TYPE;
    }

    @Override
    public String getSampleType() {
        return "delete";
    }

    @Override
    protected void operate(int idx, int all, Session session) {
        String[] path = null;
        String opType = this.getOpType();
        String lastContainer = null;
        while ((path = this.objScanner.nextObjPath(path, idx, all)) != null) {
            if (this.deleteContainer && !StringUtils.equals(lastContainer, (String)path[0])) {
                if (lastContainer != null) {
                    this.doDispose(lastContainer, this.config, session);
                }
                lastContainer = path[0];
            }
            if (path[1] == null) continue;
            Sample sample = Deleter.doDelete(path[0], path[1], this.config, session, this);
            sample.setOpType(opType);
            session.getListener().onSampleCreated(sample);
        }
        if (this.deleteContainer && lastContainer != null) {
            this.doDispose(lastContainer, this.config, session);
        }
        Date now = new Date();
        Result result = new Result(now, this.getId(), this.getOpType(), this.getSampleType(), this.getName(), true);
        session.getListener().onOperationCompleted(result);
    }

    public void doDispose(String conName, Config config, Session session) {
        if (Thread.interrupted()) {
            throw new AbortedException();
        }
        boolean isEmpty = true;
        boolean tryAgain = false;
        do {
            if (isEmpty) {
                try {
                    session.getApi().deleteContainer(conName, config);
                    isEmpty = true;
                    tryAgain = false;
                }
                catch (StorageInterruptedException storageInterruptedException) {
                    throw new AbortedException();
                }
                catch (StorageException se) {
                    String msg = "Error deleting container " + conName;
                    Cleaner.doLogErr(session.getLogger(), msg, (Exception)((Object)se));
                    if (Cleaner.isConflictException(session, (Exception)((Object)se))) {
                        isEmpty = false;
                        tryAgain = true;
                    }
                    tryAgain = false;
                }
                catch (Exception e) {
                    Cleaner.doLogErr(session.getLogger(), "fail to perform clean operation " + conName, e);
                    throw new AgentException();
                }
            }
            try {
                String[] stringArray = Cleaner.getObjectsList(conName, config, session);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String objName = stringArray[n2];
                    Deleter.doDelete(conName, objName, config, session, this);
                    ++n2;
                }
            }
            catch (StorageException se) {
                Cleaner.doLogErr(session.getLogger(), "fail to get : " + conName + " objects list ", (Exception)((Object)se));
                tryAgain = false;
            }
            catch (IOException ioe) {
                Cleaner.doLogErr(session.getLogger(), "fail to convert objects stream to string", ioe);
                tryAgain = false;
            }
            catch (Exception e) {
                Cleaner.doLogErr(session.getLogger(), "unexpected error", e);
                tryAgain = false;
            }
            isEmpty = true;
            tryAgain = true;
        } while (tryAgain);
    }

    private static String[] getObjectsList(String conName, Config config, Session session) throws IOException {
        String[] objects = new String[]{};
        StringWriter stringWriter = new StringWriter();
        try {
            IOUtils.copy((InputStream)session.getApi().getList(conName, "", config), (Writer)stringWriter);
        }
        catch (StorageException se) {
            throw se;
        }
        catch (IOException e) {
            throw e;
        }
        String objectString = stringWriter.toString();
        objects = objectString.split("\n");
        return objects;
    }

    private static boolean isConflictException(Session session, Exception e) {
        if (e != null && e.getMessage() != null) {
            try {
                if (409 == Integer.valueOf(e.getMessage().substring(9, 12))) {
                    Cleaner.doLogDebug(session.getLogger(), "catch 409 error, will clean up the unempty container and try again");
                    return true;
                }
            }
            catch (NumberFormatException ne) {
                ne.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

