/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.operator;

import com.intel.cosbench.bench.ErrorStatistics;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.driver.operator.Operator;
import com.intel.cosbench.driver.operator.Session;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.util.HashMap;

abstract class AbstractOperator
implements Operator {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    protected Config config;
    protected String id;
    protected String name;
    protected int ratio;

    AbstractOperator() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void init(String id, int ratio, String division, Config config) {
        this.config = config;
        this.id = id;
        this.ratio = ratio;
        this.name = config.get("name", this.getOpType());
    }

    @Override
    public abstract String getOpType();

    @Override
    public int getRatio() {
        return this.ratio;
    }

    @Override
    public String getSampleType() {
        return this.getOpType();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void operate(Session session) {
        int idx = session.getIndex();
        int all = session.getTotalWorkers();
        this.operate(idx, all, session);
    }

    protected static void doLogInfo(Logger logger, String message) {
        if (logger != null) {
            logger.info(message);
        } else {
            LOGGER.info(message);
        }
    }

    protected static void doLogDebug(Logger logger, String message) {
        if (logger != null) {
            logger.debug(message);
        } else {
            LOGGER.debug(message);
        }
    }

    protected static void doLogWarn(Logger logger, String message) {
        if (logger != null) {
            logger.warn(message);
        } else {
            LOGGER.warn(message);
        }
    }

    protected static void doLogErr(Logger logger, String message) {
        if (logger != null) {
            logger.error(message);
        } else {
            LOGGER.error(message);
        }
    }

    protected static void doLogErr(Logger logger, String message, Exception e) {
        if (logger != null) {
            logger.error(message, (Throwable)e);
        } else {
            LOGGER.error(message, (Throwable)e);
        }
    }

    protected abstract void operate(int var1, int var2, Session var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void errorStatisticsHandle(Exception e, Session session, String target) {
        HashMap stackTraceAndTargets;
        String trace = e.getStackTrace()[0].toString();
        trace = e.getCause() == null ? trace : String.valueOf(trace) + e.getCause().getStackTrace()[0].toString();
        ErrorStatistics errorStatistics = session.getErrorStatistics();
        HashMap hashMap = stackTraceAndTargets = errorStatistics.getStackTraceAndTargets();
        synchronized (hashMap) {
            if (!stackTraceAndTargets.containsKey(trace)) {
                errorStatistics.getStackTraceAndException().put(trace, e);
                stackTraceAndTargets.put(trace, target);
                AbstractOperator.doLogErr(session.getLogger(), "worker " + session.getIndex() + " fail to perform operation " + target, e);
            }
            String targets = (String)stackTraceAndTargets.get(trace);
            stackTraceAndTargets.put(trace, String.valueOf(targets) + ", " + target);
        }
    }

    public static void isUnauthorizedException(Exception e, Session session) {
        if (e != null && e.getMessage() != null) {
            try {
                if (401 == Integer.valueOf(e.getMessage().substring(9, 12))) {
                    session.getApi().setAuthFlag(Boolean.valueOf(false));
                    LOGGER.debug("catch 401 error from storage backend, set auth flag to false");
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

