/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.model;

import com.intel.cosbench.api.auth.AuthAPI;
import com.intel.cosbench.api.storage.StorageAPI;
import com.intel.cosbench.bench.ErrorStatistics;
import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.config.Mission;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.WorkerInfo;
import java.util.Random;
import org.apache.commons.lang.math.RandomUtils;

public class WorkerContext
implements WorkerInfo {
    private int index;
    private Mission mission;
    private transient Logger logger;
    private ErrorStatistics errorStatistics;
    private transient AuthAPI authApi;
    private transient StorageAPI storageApi;
    private volatile boolean error = false;
    private volatile boolean aborted = false;
    private volatile boolean finished = false;
    private volatile transient Snapshot snapshot = new Snapshot();
    private volatile Report report = new Report();
    private transient Random random = new Random(RandomUtils.nextLong());
    private volatile int version = 0;
    private volatile int runlen = 0;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Mission getMission() {
        return this.mission;
    }

    public void setMission(Mission mission) {
        this.mission = mission;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public AuthAPI getAuthApi() {
        return this.authApi;
    }

    public void setAuthApi(AuthAPI authApi) {
        this.authApi = authApi;
    }

    public StorageAPI getStorageApi() {
        return this.storageApi;
    }

    public void setStorageApi(StorageAPI storageApi) {
        this.storageApi = storageApi;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public Snapshot getSnapshot() {
        if (this.snapshot.getVersion() < this.version) {
            this.logger.debug("Worker[{}] : blank snapshot is generated.", (Object)this.index);
            Snapshot blankSnapshot = new Snapshot();
            blankSnapshot.setVersion(this.version);
            blankSnapshot.setMinVersion(this.version);
            blankSnapshot.setMaxVersion(this.version);
            ++this.version;
            ++this.runlen;
            return blankSnapshot;
        }
        if (this.runlen > 0) {
            Report report = this.snapshot.getReport();
            Metrics[] metrics = report.getAllMetrics();
            int i = 0;
            while (i < metrics.length) {
                this.logger.debug("Worker[{}] : ratio={}", (Object)this.index, (Object)(this.runlen + 1));
                metrics[i].setThroughput(metrics[i].getThroughput() * (double)(this.runlen + 1));
                metrics[i].setBandwidth(metrics[i].getBandwidth() * (double)(this.runlen + 1));
                ++i;
            }
            this.runlen = 0;
        }
        ++this.version;
        return this.snapshot;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
        this.snapshot.setVersion(this.version);
        this.snapshot.setMinVersion(this.version);
        this.snapshot.setMaxVersion(this.version);
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public ErrorStatistics getErrorStatistics() {
        return this.errorStatistics;
    }

    public void setErrorStatistics(ErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    public synchronized void disposeRuntime() {
        if (this.authApi != null) {
            this.authApi.dispose();
            this.authApi = null;
        }
        if (this.storageApi != null) {
            this.storageApi.dispose();
            this.storageApi = null;
        }
        this.finished = true;
    }
}

