/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.model;

import com.intel.cosbench.bench.Counter;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.driver.operator.Operator;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.utils.MapRegistry;

public class OperatorContext
implements MapRegistry.Item {
    private static Logger logger = LogFactory.getSystemLogger();
    private Operator operator;
    private Counter counter = Counter.getResCounter();

    public String getName() {
        return this.operator.getName();
    }

    public String getId() {
        return this.operator.getId();
    }

    public String getOpType() {
        return this.operator.getOpType();
    }

    public String getSampleType() {
        return this.operator.getSampleType();
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public void addSample(Sample sample) {
        if (!sample.isSucc()) {
            return;
        }
        this.doAddSample(sample);
    }

    private void doAddSample(Sample sample) {
        long time = sample.getTime();
        long start = System.nanoTime();
        this.counter.doAdd(time);
        long end = System.nanoTime();
        double dura = end - start;
        if (dura >= 500000.0) {
            logger.warn("heavy atomic op overhead detected: {}ms", (Object)(dura / 1000000.0));
        }
    }

    public Counter getCounter() {
        return this.counter;
    }
}

