/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.model;

import com.intel.cosbench.bench.Counter;
import com.intel.cosbench.bench.ErrorStatistics;
import com.intel.cosbench.bench.Histogram;
import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.ReportMerger;
import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.bench.SnapshotMerger;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.Mission;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.config.common.KVConfigParser;
import com.intel.cosbench.driver.model.MissionListener;
import com.intel.cosbench.driver.model.OperatorContext;
import com.intel.cosbench.driver.model.OperatorRegistry;
import com.intel.cosbench.driver.model.WorkerContext;
import com.intel.cosbench.driver.model.WorkerRegistry;
import com.intel.cosbench.driver.util.OperationPicker;
import com.intel.cosbench.log.LogManager;
import com.intel.cosbench.model.MissionInfo;
import com.intel.cosbench.model.MissionState;
import com.intel.cosbench.model.StateInfo;
import com.intel.cosbench.model.StateRegistry;
import com.intel.cosbench.model.WorkerInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

public class MissionContext
implements MissionInfo {
    private String id;
    private Date date;
    private volatile MissionState state;
    private StateRegistry stateHistory = new StateRegistry();
    private transient XmlConfig config;
    private volatile transient Future<?> future;
    private Mission mission;
    private LogManager logManager;
    private ErrorStatistics errorStatistics;
    private transient OperationPicker operationPicker;
    private transient OperatorRegistry operatorRegistry;
    private WorkerRegistry workerRegistry;
    private volatile Report report = null;
    private transient List<MissionListener> listeners = new ArrayList<MissionListener>();
    private static final String GENERATE_HISTOGRAM_KEY = "histogram";
    private static final boolean DEFAULT_GENERATE_HISTOGRAM = true;

    public List<Report> getWorkerReports() {
        ArrayList<Report> wReports = new ArrayList<Report>();
        Iterator iterator = this.workerRegistry.iterator();
        while (iterator.hasNext()) {
            WorkerContext wContext = (WorkerContext)iterator.next();
            wReports.add(wContext.getReport());
        }
        return wReports;
    }

    public MissionContext() {
        this.errorStatistics = new ErrorStatistics();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public MissionState getState() {
        return this.state;
    }

    public void setState(MissionState state) {
        this.state = state;
        this.stateHistory.addState(state.name());
        if (MissionState.isStopped((MissionState)state) && !state.equals((Object)MissionState.FAILED)) {
            this.fireMissionStopped();
        }
    }

    private void fireMissionStopped() {
        if (this.report == null) {
            this.report = this.mergeReport();
        }
        for (MissionListener listener : this.listeners) {
            listener.missionStopped(this);
        }
    }

    private Report mergeReport() {
        ReportMerger merger = new ReportMerger();
        Iterator iterator = this.workerRegistry.iterator();
        while (iterator.hasNext()) {
            WorkerContext worker = (WorkerContext)iterator.next();
            merger.add(worker.getReport());
        }
        Report report = merger.merge();
        Config missionConfig = KVConfigParser.parse((String)this.mission.getConfig());
        boolean histogram = missionConfig.getBoolean(GENERATE_HISTOGRAM_KEY, true);
        if (histogram) {
            this.generateHistogram(report);
        }
        return report;
    }

    private void generateHistogram(Report report) {
        OperatorRegistry registry = this.operatorRegistry;
        for (Metrics metrics : report) {
            OperatorContext op = registry.getOperator(metrics.getOpId());
            metrics.setLatency(Histogram.convert((Counter)op.getCounter()));
        }
    }

    public StateInfo[] getStateHistory() {
        return this.stateHistory.getAllStates();
    }

    public XmlConfig getConfig() {
        return this.config;
    }

    public void setConfig(XmlConfig config) {
        this.config = config;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    public void setFuture(Future<?> future) {
        this.future = future;
    }

    public Mission getMission() {
        return this.mission;
    }

    public void setMission(Mission mission) {
        this.mission = mission;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public void setLogManager(LogManager logManager) {
        this.logManager = logManager;
    }

    public ErrorStatistics getErrorStatistics() {
        return this.errorStatistics;
    }

    public void setErrorStatistics(ErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    public OperationPicker getOperationPicker() {
        return this.operationPicker;
    }

    public void setOperationPicker(OperationPicker operationPicker) {
        this.operationPicker = operationPicker;
    }

    public OperatorRegistry getOperatorRegistry() {
        return this.operatorRegistry;
    }

    public void setOperatorRegistry(OperatorRegistry operatorRegistry) {
        this.operatorRegistry = operatorRegistry;
    }

    public WorkerRegistry getWorkerRegistry() {
        return this.workerRegistry;
    }

    public int getWorkerCount() {
        return this.workerRegistry.getSize();
    }

    public WorkerInfo[] getWorkerInfos() {
        return this.workerRegistry.getAllWorkers();
    }

    public void setWorkerRegistry(WorkerRegistry workerRegistry) {
        this.workerRegistry = workerRegistry;
    }

    public Snapshot getSnapshot() {
        SnapshotMerger merger = new SnapshotMerger();
        Iterator iterator = this.workerRegistry.iterator();
        while (iterator.hasNext()) {
            WorkerContext worker = (WorkerContext)iterator.next();
            merger.add(worker.getSnapshot());
        }
        return merger.merge();
    }

    public Report getReport() {
        return this.report != null ? this.report : new Report();
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void addListener(MissionListener listener) {
        this.listeners.add(listener);
    }

    public void disposeRuntime() {
        if (MissionState.isStopped((MissionState)this.state)) {
            Iterator iterator = this.workerRegistry.iterator();
            while (iterator.hasNext()) {
                WorkerContext worker = (WorkerContext)iterator.next();
                worker.disposeRuntime();
            }
            this.config = null;
            this.future = null;
            this.operationPicker = null;
            this.operatorRegistry = null;
            this.listeners = null;
            this.logManager.dispose();
        }
    }
}

