/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.iterator;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.iterator.IntIterator;
import org.apache.commons.lang.StringUtils;

class RangeIterator
implements IntIterator {
    private int lower;
    private int upper;

    public RangeIterator(int lower, int upper) {
        if (lower <= 0 || upper <= 0 || lower > upper) {
            throw new IllegalArgumentException();
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public int next(int cursor) {
        return this.next(cursor, 1, 1);
    }

    @Override
    public int next(int cursor, int idx, int all) {
        int range = this.upper - this.lower + 1;
        int base = range / all;
        int extra = range % all;
        int offset = base * (idx - 1) + (extra >= idx - 1 ? idx - 1 : extra);
        int segment = base + (extra >= idx ? 1 : 0);
        int limit = segment + offset + this.lower;
        cursor = cursor <= 0 ? limit - segment : cursor + 1;
        return cursor < limit ? cursor : -1;
    }

    public static RangeIterator parse(String pattern) {
        try {
            return RangeIterator.tryParseOld(pattern);
        }
        catch (Exception exception) {
            if (!StringUtils.startsWith((String)pattern, (String)"r(")) {
                return null;
            }
            try {
                return RangeIterator.tryParse(pattern);
            }
            catch (Exception exception2) {
                String msg = "illegal iteration pattern: " + pattern;
                throw new ConfigException(msg);
            }
        }
    }

    private static RangeIterator tryParse(String pattern) {
        pattern = StringUtils.substringBetween((String)pattern, (String)"(", (String)")");
        String[] args = StringUtils.split((String)pattern, (String)",");
        int lower = Integer.parseInt(args[0]);
        int upper = Integer.parseInt(args[1]);
        return new RangeIterator(lower, upper);
    }

    private static RangeIterator tryParseOld(String pattern) {
        String[] args = StringUtils.split((String)pattern, (char)'-');
        int lower = Integer.parseInt(args[0]);
        int upper = Integer.parseInt(args[1]);
        return new RangeIterator(lower, upper);
    }
}

