/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CountingInputStream;

public class XferCountingInputStream
extends CountingInputStream {
    private long xferStart = 0L;
    private long xferEnd = 0L;
    private boolean isFirstByte = true;

    public XferCountingInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int result = super.read();
        this.recordTime();
        return result;
    }

    public int read(byte[] b) throws IOException {
        int result = super.read(b);
        this.recordTime();
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        this.recordTime();
        return result;
    }

    private void recordTime() {
        if (this.isFirstByte) {
            this.xferStart = System.currentTimeMillis();
            this.isFirstByte = false;
        }
        this.xferEnd = System.currentTimeMillis();
    }

    public long getXferTime() {
        long xferTime = this.xferEnd - this.xferStart;
        return xferTime > 0L ? xferTime : 0L;
    }
}

