/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.generator.IntGenerator;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

class UniformIntGenerator
implements IntGenerator {
    private int lower;
    private int upper;
    private static int MAXupper = Integer.MAX_VALUE;

    public UniformIntGenerator(int lower, int upper) {
        if (lower <= 0 || upper <= 0 || lower > upper) {
            throw new IllegalArgumentException();
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public int next(Random random) {
        return this.next(random, 1, 1);
    }

    @Override
    public int next(Random random, int idx, int all) {
        int range = this.upper - this.lower + 1;
        int base = range / all;
        int extra = range % all;
        int offset = base * (idx - 1) + (extra >= idx - 1 ? idx - 1 : extra);
        int segment = base + (extra >= idx ? 1 : 0);
        int value = RandomUtils.nextInt((Random)random, (int)segment);
        return value += offset + this.lower;
    }

    public static UniformIntGenerator parse(String pattern) {
        if (!StringUtils.startsWith((String)pattern, (String)"u(")) {
            return null;
        }
        try {
            return UniformIntGenerator.tryParse(pattern);
        }
        catch (Exception exception) {
            String msg = "illegal uniform distribution pattern: " + pattern;
            throw new ConfigException(msg);
        }
    }

    private static UniformIntGenerator tryParse(String pattern) {
        pattern = StringUtils.substringBetween((String)pattern, (String)"(", (String)")");
        String[] args = StringUtils.split((String)pattern, (char)',');
        int lower = Integer.parseInt(args[0]);
        int upper = args.length == 2 ? Integer.parseInt(args[1]) : MAXupper;
        return new UniformIntGenerator(lower, upper);
    }

    public static int getMAXupper() {
        return MAXupper;
    }
}

