/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.generator.IntGenerator;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;

class SequentialIntGenerator
implements IntGenerator {
    private int lower;
    private int range;
    private AtomicLong cursor;

    public SequentialIntGenerator(int lower, int upper) {
        if (lower <= 0 || upper <= 0 || lower > upper) {
            throw new IllegalArgumentException();
        }
        this.lower = lower;
        this.range = upper - lower + 1;
        this.cursor = new AtomicLong();
        this.cursor.set(-1L);
    }

    @Override
    public int next(Random random) {
        return (int)((long)this.lower + this.cursor.incrementAndGet() % (long)this.range);
    }

    @Override
    public int next(Random random, int idx, int all) {
        return this.next(random);
    }

    public static SequentialIntGenerator parse(String pattern) {
        if (!StringUtils.startsWith((String)pattern, (String)"s(")) {
            return null;
        }
        try {
            return SequentialIntGenerator.tryParse(pattern);
        }
        catch (NullPointerException nullPointerException) {
            String msg = "illegal iteration pattern: " + pattern;
            throw new ConfigException(msg);
        }
    }

    private static SequentialIntGenerator tryParse(String pattern) {
        pattern = StringUtils.substringBetween((String)pattern, (String)"(", (String)")");
        String[] args = StringUtils.split((String)pattern, (String)",");
        int lower = Integer.parseInt(args[0]);
        int upper = Integer.parseInt(args[1]);
        return new SequentialIntGenerator(lower, upper);
    }
}

