/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.generator.IntGenerator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public class RangeIntGenerator
implements IntGenerator {
    private int lower;
    private int upper;
    private AtomicInteger[] cursors = null;

    public static void main(String[] args) {
        int i = 0;
        Vector<TestThread> threads = new Vector<TestThread>();
        RangeIntGenerator gen = RangeIntGenerator.parse("r(51,1000)");
        i = 0;
        while (i < 5) {
            TestThread thread = new TestThread(gen, i + 1, 5);
            threads.add(thread);
            thread.start();
            ++i;
        }
        try {
            i = 0;
            while (i < 5) {
                ((TestThread)threads.elementAt(i)).join();
                ++i;
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public RangeIntGenerator(int lower, int upper) {
        if (lower <= 0 || upper <= 0 || lower > upper) {
            throw new IllegalArgumentException();
        }
        this.lower = lower;
        this.upper = upper;
    }

    private synchronized void init(int all) {
        if (this.cursors != null) {
            return;
        }
        this.cursors = new AtomicInteger[all];
        int i = 0;
        while (i < all) {
            this.cursors[i] = new AtomicInteger(0);
            ++i;
        }
    }

    @Override
    public int next(Random random) {
        return this.next(random, 1, 1);
    }

    @Override
    public int next(Random random, int idx, int all) {
        if (this.cursors == null) {
            this.init(all);
        }
        int range = this.upper - this.lower + 1;
        int base = range / all;
        int extra = range % all;
        int offset = base * (idx - 1) + (extra >= idx - 1 ? idx - 1 : extra);
        int segment = base + (extra >= idx ? 1 : 0);
        return this.lower + offset + this.cursors[idx - 1].getAndIncrement() % segment;
    }

    public static RangeIntGenerator parse(String pattern) {
        try {
            return RangeIntGenerator.tryParseOld(pattern);
        }
        catch (Exception exception) {
            if (!StringUtils.startsWith((String)pattern, (String)"r(")) {
                return null;
            }
            try {
                return RangeIntGenerator.tryParse(pattern);
            }
            catch (Exception exception2) {
                String msg = "illegal iteration pattern: " + pattern;
                throw new ConfigException(msg);
            }
        }
    }

    private static RangeIntGenerator tryParse(String pattern) {
        pattern = StringUtils.substringBetween((String)pattern, (String)"(", (String)")");
        String[] args = StringUtils.split((String)pattern, (String)",");
        int lower = Integer.parseInt(args[0]);
        int upper = Integer.parseInt(args[1]);
        return new RangeIntGenerator(lower, upper);
    }

    private static RangeIntGenerator tryParseOld(String pattern) {
        String[] args = StringUtils.split((String)pattern, (char)'-');
        int lower = Integer.parseInt(args[0]);
        int upper = Integer.parseInt(args[1]);
        return new RangeIntGenerator(lower, upper);
    }

    static class TestThread
    extends Thread {
        private int all;
        private int idx;
        private IntGenerator generator;
        private Random rnd;

        public TestThread(IntGenerator gen, int idx, int all) {
            this.all = all;
            this.idx = idx;
            this.setName("Thread[" + idx + "]");
            this.generator = gen;
            this.rnd = new Random(123L);
        }

        @Override
        public void run() {
            int i = 0;
            LinkedList<Integer> results = new LinkedList<Integer>();
            try {
                while (i++ < 11) {
                    int answer = this.generator.next(this.rnd, this.idx, this.all);
                    if (!results.contains(answer)) {
                        System.out.println(String.valueOf(this.getName()) + ": " + answer);
                    } else {
                        System.out.println(String.valueOf(this.getName()) + ": " + answer + " I did get this before!");
                    }
                    results.add(answer);
                    TestThread.sleep(5L);
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }
}

