/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import com.intel.cosbench.driver.util.HashUtil;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang.math.RandomUtils;

public class RandomInputStream
extends NullInputStream {
    private static final int SIZE = 4096;
    private byte[] buffer;
    private boolean hashCheck = false;
    private HashUtil util = null;
    private int hashLen = 0;
    private byte[] hashBytes;
    private long size = 0L;
    private long processed = 0L;
    private static Logger logger = LogFactory.getSystemLogger();

    public RandomInputStream(long size, Random random, boolean isRandom, boolean hashCheck) {
        super(size);
        this.hashCheck = hashCheck;
        try {
            this.util = new HashUtil();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Alogrithm not found", (Throwable)e);
        }
        this.hashLen = this.util.getHashLen();
        if (size <= (long)this.hashLen) {
            logger.warn("The size is too small to embed checksum, will ignore integrity checking.");
            this.hashCheck = false;
            this.util = null;
            this.hashLen = 0;
        }
        this.size = size;
        this.buffer = new byte[4096];
        if (isRandom) {
            int i = 0;
            while (i < 4096) {
                this.buffer[i] = (byte)(RandomUtils.nextInt((Random)random, (int)26) + 97);
                ++i;
            }
        }
    }

    protected int processByte() {
        throw new UnsupportedOperationException("do not read byte by byte");
    }

    protected void processBytes(byte[] bytes, int offset, int length) {
        if (!this.hashCheck) {
            int segment;
            do {
                segment = length > 4096 ? 4096 : length;
                System.arraycopy(this.buffer, 0, bytes, offset, segment);
                offset += segment;
            } while ((length -= segment) > 0);
        } else {
            int segment;
            if (length <= this.hashLen) {
                System.arraycopy(this.hashBytes, this.hashLen - length, bytes, 0, length);
                return;
            }
            int gap = (int)(this.processed + (long)length - (this.size - (long)this.hashLen));
            if (gap > 0) {
                length -= gap;
            }
            this.processed += (long)length;
            do {
                segment = length > 4096 ? 4096 : length;
                System.arraycopy(this.buffer, 0, bytes, offset, segment);
                this.util.update(this.buffer, 0, segment);
                offset += segment;
            } while ((length -= segment) > 0);
            if (gap <= this.hashLen && gap >= 0) {
                String hashString = this.util.calculateHash();
                try {
                    this.hashBytes = hashString.getBytes("UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.hashBytes = hashString.getBytes();
                }
                if (gap > 0) {
                    System.arraycopy(this.hashBytes, 0, bytes, offset, gap);
                }
            }
        }
    }
}

