/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.generator.IntGenerator;
import com.intel.cosbench.driver.generator.UniformIntGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class HistogramIntGenerator
implements IntGenerator {
    private final Bucket[] buckets;
    private final int totalWeight;

    public HistogramIntGenerator(Bucket[] buckets) {
        this.buckets = buckets;
        this.totalWeight = buckets[buckets.length - 1].cumulativeWeight;
    }

    @Override
    public int next(Random random) {
        int next = RandomUtils.nextInt((Random)random, (int)this.totalWeight);
        Bucket[] bucketArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            Bucket bucket = bucketArray[n2];
            if (next <= bucket.cumulativeWeight) {
                return bucket.gen.next(random);
            }
            ++n2;
        }
        return 0;
    }

    @Override
    public int next(Random random, int idx, int all) {
        throw new NotImplementedException();
    }

    public static HistogramIntGenerator parse(String pattern) {
        if (!StringUtils.startsWith((String)pattern, (String)"h(")) {
            return null;
        }
        try {
            return HistogramIntGenerator.tryParse(pattern);
        }
        catch (Exception exception) {
            String msg = "illegal histogram distribution pattern: " + pattern;
            throw new ConfigException(msg);
        }
    }

    private static HistogramIntGenerator tryParse(String pattern) {
        pattern = StringUtils.substringBetween((String)pattern, (String)"(", (String)")");
        String[] args = StringUtils.split((String)pattern, (char)',');
        ArrayList<Bucket> bucketsList = new ArrayList<Bucket>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            int weight;
            int upper;
            int lower;
            String arg = stringArray[n2];
            int v1 = StringUtils.indexOf((String)arg, (char)'|');
            int v2 = StringUtils.lastIndexOf((String)arg, (char)'|');
            boolean isOpenRange = v2 - v1 == 1;
            String[] values = StringUtils.split((String)arg, (char)'|');
            if (isOpenRange) {
                lower = Integer.parseInt(values[0]);
                upper = UniformIntGenerator.getMAXupper();
                weight = Integer.parseInt(values[1]);
            } else {
                if (values.length != 3) {
                    throw new IllegalArgumentException();
                }
                lower = Integer.parseInt(values[0]);
                upper = Integer.parseInt(values[1]);
                weight = Integer.parseInt(values[2]);
            }
            bucketsList.add(new Bucket(lower, upper, weight));
            ++n2;
        }
        if (bucketsList.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Collections.sort(bucketsList, new LowerComparator());
        Bucket[] buckets = bucketsList.toArray(new Bucket[0]);
        int cumulativeWeight = 0;
        Bucket[] bucketArray = buckets;
        int n3 = buckets.length;
        int n4 = 0;
        while (n4 < n3) {
            Bucket bucket = bucketArray[n4];
            bucket.cumulativeWeight = (cumulativeWeight += bucket.weight);
            ++n4;
        }
        return new HistogramIntGenerator(buckets);
    }

    private static class Bucket {
        private final int lower;
        private final UniformIntGenerator gen;
        private final int weight;
        private int cumulativeWeight;

        Bucket(int lower, int upper, int weight) {
            this.lower = lower;
            this.gen = new UniformIntGenerator(lower, upper);
            this.weight = weight;
            this.cumulativeWeight = 0;
        }
    }

    private static class LowerComparator
    implements Comparator<Bucket> {
        private LowerComparator() {
        }

        @Override
        public int compare(Bucket b1, Bucket b2) {
            return b1.lower - b2.lower;
        }
    }
}

