/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.generator.ConstantIntGenerator;
import com.intel.cosbench.driver.generator.DefaultSizeGenerator;
import com.intel.cosbench.driver.generator.HistogramIntGenerator;
import com.intel.cosbench.driver.generator.IntGenerator;
import com.intel.cosbench.driver.generator.NameGenerator;
import com.intel.cosbench.driver.generator.NumericNameGenerator;
import com.intel.cosbench.driver.generator.RangeIntGenerator;
import com.intel.cosbench.driver.generator.SequentialIntGenerator;
import com.intel.cosbench.driver.generator.SizeGenerator;
import com.intel.cosbench.driver.generator.UniformIntGenerator;

public class Generators {
    public static NameGenerator getNameGenerator(String pattern, String prefix, String suffix) {
        NumericNameGenerator generator = new NumericNameGenerator();
        generator.setPrefix(prefix);
        generator.setSuffix(suffix);
        generator.setGenerator(Generators.getIntGenerator(pattern));
        return generator;
    }

    public static SizeGenerator getSizeGenerator(String pattern) {
        DefaultSizeGenerator generator = new DefaultSizeGenerator();
        generator.setUnit(pattern);
        generator.setGenerator(Generators.getIntGenerator(pattern));
        return generator;
    }

    private static IntGenerator getIntGenerator(String pattern) {
        IntGenerator generator = null;
        generator = ConstantIntGenerator.parse(pattern);
        if (generator != null) {
            return generator;
        }
        generator = UniformIntGenerator.parse(pattern);
        if (generator != null) {
            return generator;
        }
        generator = RangeIntGenerator.parse(pattern);
        if (generator != null) {
            return generator;
        }
        generator = SequentialIntGenerator.parse(pattern);
        if (generator != null) {
            return generator;
        }
        generator = HistogramIntGenerator.parse(pattern);
        if (generator != null) {
            return generator;
        }
        String msg = "unrecognized distribution: " + pattern;
        throw new ConfigException(msg);
    }
}

