/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.generator.IntGenerator;
import com.intel.cosbench.driver.generator.SizeGenerator;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

class DefaultSizeGenerator
implements SizeGenerator {
    private long base;
    private IntGenerator generator;

    public long setUnit(String unit) {
        if (StringUtils.endsWith((String)unit, (String)"GB")) {
            this.base = 1000000000L;
            return 1000000000L;
        }
        if (StringUtils.endsWith((String)unit, (String)"MB")) {
            this.base = 1000000L;
            return 1000000L;
        }
        if (StringUtils.endsWith((String)unit, (String)"KB")) {
            this.base = 1000L;
            return 1000L;
        }
        if (StringUtils.endsWith((String)unit, (String)"B")) {
            this.base = 1L;
            return 1L;
        }
        String msg = "unrecognized size unit: " + unit;
        throw new ConfigException(msg);
    }

    public void setGenerator(IntGenerator generator) {
        this.generator = generator;
    }

    @Override
    public long next(Random random) {
        return (long)this.generator.next(random) * this.base;
    }
}

