/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.generator;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.driver.generator.IntGenerator;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

class ConstantIntGenerator
implements IntGenerator {
    private int value;

    private ConstantIntGenerator(int value) {
        this.value = value;
    }

    @Override
    public int next(Random random) {
        return this.value;
    }

    @Override
    public int next(Random random, int idx, int all) {
        return this.next(random);
    }

    public static ConstantIntGenerator parse(String pattern) {
        if (!StringUtils.startsWith((String)pattern, (String)"c(")) {
            return null;
        }
        try {
            return ConstantIntGenerator.tryParse(pattern);
        }
        catch (Exception exception) {
            String msg = "illegal constant distribution pattern: " + pattern;
            throw new ConfigException(msg);
        }
    }

    private static ConstantIntGenerator tryParse(String pattern) {
        pattern = StringUtils.substringBetween((String)pattern, (String)"(", (String)")");
        String[] args = StringUtils.split((String)pattern, (char)',');
        int value = Integer.parseInt(args[0]);
        return new ConstantIntGenerator(value);
    }
}

