/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.agent;

import com.intel.cosbench.api.auth.AuthException;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.StorageAPI;
import com.intel.cosbench.bench.ErrorStatistics;
import com.intel.cosbench.bench.Mark;
import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.bench.Result;
import com.intel.cosbench.bench.Sample;
import com.intel.cosbench.bench.Snapshot;
import com.intel.cosbench.bench.Status;
import com.intel.cosbench.config.Mission;
import com.intel.cosbench.driver.agent.AbstractAgent;
import com.intel.cosbench.driver.agent.AgentException;
import com.intel.cosbench.driver.agent.WatchDog;
import com.intel.cosbench.driver.model.OperatorContext;
import com.intel.cosbench.driver.model.OperatorRegistry;
import com.intel.cosbench.driver.model.WorkerContext;
import com.intel.cosbench.driver.operator.OperationListener;
import com.intel.cosbench.driver.operator.Session;
import com.intel.cosbench.driver.util.AuthCachePool;
import com.intel.cosbench.driver.util.OperationPicker;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.service.AbortedException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;

class WorkAgent
extends AbstractAgent
implements Session,
OperationListener {
    private long start;
    private long begin;
    private long end;
    private long timeout;
    private long lop;
    private long lbegin;
    private long lsample;
    private long lrsample;
    private long frsample;
    private long curr;
    private long lcheck;
    private long check;
    private long interval;
    private int totalOps;
    private long totalBytes;
    private boolean has_histo;
    private OperationPicker operationPicker;
    private OperatorRegistry operatorRegistry;
    private WatchDog dog = new WatchDog();
    private Status currMarks = new Status();
    private Status globalMarks = new Status();

    @Override
    public void setWorkerContext(WorkerContext workerContext) {
        super.setWorkerContext(workerContext);
        this.has_histo = workerContext.getMission().hasHisto();
        this.dog.setWorkerContext(workerContext);
    }

    public void setOperationPicker(OperationPicker operationPicker) {
        this.operationPicker = operationPicker;
    }

    public void setOperatorRegistry(OperatorRegistry operatorRegistry) {
        this.operatorRegistry = operatorRegistry;
    }

    @Override
    public int getIndex() {
        return this.workerContext.getIndex();
    }

    @Override
    public int getTotalWorkers() {
        return this.workerContext.getMission().getTotalWorkers();
    }

    @Override
    public Random getRandom() {
        return this.workerContext.getRandom();
    }

    @Override
    public StorageAPI getApi() {
        return this.workerContext.getStorageApi();
    }

    @Override
    public Logger getLogger() {
        return this.workerContext.getLogger();
    }

    @Override
    public ErrorStatistics getErrorStatistics() {
        return this.workerContext.getErrorStatistics();
    }

    @Override
    public OperationListener getListener() {
        return this;
    }

    @Override
    protected void execute() {
        this.initTimes();
        this.initLimites();
        this.initMarks();
        this.dog.watch(this.timeout);
        try {
            this.doWork();
        }
        finally {
            this.dog.dismiss();
        }
    }

    private void initTimes() {
        Mission mission = this.workerContext.getMission();
        this.interval = mission.getInterval();
        this.curr = this.start = System.currentTimeMillis();
        this.lcheck = this.start;
        this.check = this.lcheck + this.interval * 1000L;
        this.begin = this.start;
        this.timeout = 0L;
        this.lrsample = this.lsample = this.start;
        this.lop = this.lsample;
        this.end = Long.MAX_VALUE;
        this.lbegin = Long.MAX_VALUE;
        this.frsample = Long.MAX_VALUE;
    }

    private void initLimites() {
        Mission mission = this.workerContext.getMission();
        this.totalOps = mission.getTotalOps() / mission.getTotalWorkers();
        this.totalBytes = mission.getTotalBytes() / (long)mission.getTotalWorkers();
        if (mission.getRuntime() == 0) {
            return;
        }
        this.begin = this.start + (long)(mission.getRampup() * 1000);
        this.end = this.begin + (long)(mission.getRuntime() * 1000);
        this.timeout = this.end + (long)(mission.getRampdown() * 1000);
    }

    private void initMarks() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        Iterator iterator = this.operatorRegistry.iterator();
        while (iterator.hasNext()) {
            OperatorContext op = (OperatorContext)iterator.next();
            types.add(Mark.getMarkType((String)op.getId(), (String)op.getOpType(), (String)op.getSampleType(), (String)op.getName()));
        }
        for (String type : types) {
            this.currMarks.addMark(Mark.newMark((String)type));
        }
        for (String type : types) {
            this.globalMarks.addMark(Mark.newMark((String)type));
        }
    }

    private void doWork() {
        this.doSnapshot();
        while (!this.workerContext.isFinished()) {
            try {
                this.performOperation();
            }
            catch (AbortedException abortedException) {
                if (this.lrsample > this.frsample) {
                    this.doSummary();
                }
                this.workerContext.setFinished(true);
            }
        }
        this.doSnapshot();
    }

    private void performOperation() {
        if (this.workerContext.getAuthApi() == null || this.workerContext.getStorageApi() == null) {
            throw new AbortedException();
        }
        if (!this.workerContext.getStorageApi().isAuthValid().booleanValue()) {
            this.reLogin();
        }
        this.lbegin = System.currentTimeMillis();
        Random random = this.workerContext.getRandom();
        String op = this.operationPicker.pickOperation(random);
        OperatorContext context = this.operatorRegistry.getOperator(op);
        try {
            context.getOperator().operate(this);
        }
        catch (AuthException authException) {
            this.reLogin();
        }
    }

    @Override
    public void onSampleCreated(Sample sample) {
        this.curr = sample.getTimestamp().getTime();
        String type = Mark.getMarkType((String)sample.getOpId(), (String)sample.getOpType(), (String)sample.getSampleType(), (String)sample.getOpName());
        this.currMarks.getMark(type).addSample(sample);
        if (this.lbegin >= this.begin && this.lbegin < this.end && this.curr > this.begin && this.curr <= this.end) {
            this.globalMarks.getMark(type).addSample(sample);
            this.operatorRegistry.getOperator(sample.getOpId()).addSample(sample);
            if (this.lbegin < this.frsample) {
                this.frsample = this.lbegin;
            }
            this.lrsample = this.curr;
        }
        this.lsample = this.curr;
        this.trySnapshot();
    }

    private void trySnapshot() {
        if (this.lsample < this.check) {
            return;
        }
        this.doSnapshot();
        this.lcheck = System.currentTimeMillis();
        this.check = this.lcheck + this.interval * 1000L;
    }

    private void doSnapshot() {
        long window = this.lsample - this.lcheck;
        Report report = new Report();
        for (Mark mark : this.currMarks) {
            report.addMetrics(Metrics.convert((Mark)mark, (long)window));
            mark.clear();
        }
        Snapshot snapshot = new Snapshot(report);
        this.workerContext.setSnapshot(snapshot);
    }

    @Override
    public void onOperationCompleted(Result result) {
        this.curr = result.getTimestamp().getTime();
        String type = Mark.getMarkType((String)result.getOpId(), (String)result.getOpType(), (String)result.getSampleType(), (String)result.getOpName());
        this.currMarks.getMark(type).addOperation(result);
        if (this.lop >= this.begin && this.lop < this.end && this.curr > this.begin && this.curr <= this.end) {
            this.globalMarks.getMark(type).addOperation(result);
        }
        this.lop = this.curr;
        this.trySummary();
    }

    private void trySummary() {
        if (!(this.timeout > 0L && this.curr >= this.timeout || this.totalOps > 0 && this.getTotalOps() >= this.totalOps || this.totalBytes > 0L && this.getTotalBytes() >= this.totalBytes)) {
            return;
        }
        this.doSummary();
        this.workerContext.setFinished(true);
    }

    private void doSummary() {
        long window = this.lrsample - this.frsample;
        Report report = new Report();
        for (Mark mark : this.globalMarks) {
            report.addMetrics(Metrics.convert((Mark)mark, (long)window));
        }
        this.workerContext.setReport(report);
    }

    private int getTotalOps() {
        int sum = 0;
        for (Mark mark : this.globalMarks) {
            sum += mark.getTotalOpCount();
        }
        return sum;
    }

    private long getTotalBytes() {
        long bytes = 0L;
        for (Mark mark : this.globalMarks) {
            bytes += mark.getByteCount();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reLogin() {
        LOGGER.debug("WorkAgent {} auth failed, now relogin", (Object)this.workerContext.getIndex());
        AuthContext authContext = this.workerContext.getStorageApi().getAuthContext();
        AuthCachePool authCachePool = AuthCachePool.getInstance();
        synchronized (authCachePool) {
            AuthCachePool.getInstance().remove(authContext.getID());
        }
        try {
            this.workerContext.getAuthApi().init();
            authContext = this.workerContext.getAuthApi().login();
            this.workerContext.getStorageApi().setAuthContext(authContext);
            authCachePool = AuthCachePool.getInstance();
            synchronized (authCachePool) {
                AuthCachePool.getInstance().put(authContext.getID(), authContext);
            }
            LOGGER.debug("WorkAgent {} relogin successfully", (Object)this.workerContext.getIndex());
        }
        catch (AuthException ae) {
            this.workerContext.getAuthApi().dispose();
            LOGGER.error("agent " + this.workerContext.getIndex() + " failed to login", (Throwable)ae);
            throw new AgentException();
        }
    }
}

