/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.agent;

import com.intel.cosbench.driver.model.WorkerContext;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

class WatchDog
extends TimerTask {
    private static final Logger LOGGER = LogFactory.getSystemLogger();
    private WorkerContext workerContext;
    private volatile boolean cancel = false;
    private Timer timer = new Timer();

    public void setWorkerContext(WorkerContext workerContext) {
        this.workerContext = workerContext;
    }

    public void dismiss() {
        this.timer.cancel();
        this.cancel = true;
        LOGGER.debug("timeout service has been dismissed");
    }

    public void watch(long timeout) {
        if (timeout != 0L) {
            this.timer.schedule((TimerTask)this, new Date(timeout + 1000L));
        }
    }

    @Override
    public void run() {
        int idx = this.workerContext.getIndex();
        int secs = 10;
        while (secs > 0 && !this.cancel) {
            LOGGER.debug("work agent {} will timeout in {} seconds", (Object)idx, (Object)secs);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
            secs -= 5;
        }
        if (!this.cancel) {
            this.workerContext.getStorageApi().abort();
            this.workerContext.disposeRuntime();
            LOGGER.debug("work agent {} has been alerted for timeout", (Object)idx);
        } else {
            LOGGER.debug("work agent {} has completed before timeout", (Object)idx);
        }
    }
}

