/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.agent;

import com.intel.cosbench.api.auth.AuthAPI;
import com.intel.cosbench.api.auth.AuthBadException;
import com.intel.cosbench.api.auth.AuthConstants;
import com.intel.cosbench.api.auth.AuthException;
import com.intel.cosbench.api.auth.AuthInterruptedException;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.StorageAPI;
import com.intel.cosbench.driver.agent.AbstractAgent;
import com.intel.cosbench.driver.agent.AgentException;
import com.intel.cosbench.driver.util.AuthCachePool;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.service.AbortedException;
import java.util.Random;
import org.apache.commons.lang.math.RandomUtils;

class AuthAgent
extends AbstractAgent {
    private int loginAttempts;

    public void setLoginAttempts(int loginAttempts) {
        this.loginAttempts = loginAttempts;
    }

    @Override
    protected void execute() {
        Logger logger = this.getMissionLogger();
        try {
            try {
                StorageAPI storageApi = this.workerContext.getStorageApi();
                storageApi.setAuthContext(this.login());
            }
            catch (AuthInterruptedException authInterruptedException) {
                throw new AbortedException();
            }
            catch (AuthBadException be) {
                logger.error("bad username and password", (Throwable)be);
                throw new AgentException();
            }
            catch (AuthException e) {
                if (this.loginAttempts == 1) {
                    logger.error("unable to login", (Throwable)e);
                } else {
                    logger.error("still unable to login", (Throwable)e);
                }
                logger.error("fail to login with {} attempt(s)", (Object)this.loginAttempts);
                throw new AgentException();
            }
        }
        finally {
            AuthAPI authApi = this.workerContext.getAuthApi();
            authApi.dispose();
        }
        int idx = this.workerContext.getIndex();
        logger.debug("worker {} has been successfully authed", (Object)idx);
    }

    private AuthContext login() {
        Logger logger = this.getMissionLogger();
        this.workerContext.getAuthApi();
        int attempts = 0;
        while (attempts++ < this.loginAttempts - 1) {
            try {
                return this.tryLogin();
            }
            catch (AuthInterruptedException ie) {
                throw ie;
            }
            catch (AuthBadException be) {
                throw be;
            }
            catch (AuthException e) {
                logger.error("unable to login, will try again later", (Throwable)e);
                this.sleepForSometime();
            }
        }
        return this.tryLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthContext tryLogin() {
        AuthContext auth_context;
        Logger logger = this.getMissionLogger();
        logger.debug("begin to login, will attempt {} times", (Object)this.loginAttempts);
        AuthAPI authApi = this.workerContext.getAuthApi();
        AuthContext import_context = authApi.getParms();
        String id = import_context.getID();
        boolean caching = import_context.getBoolean("caching", AuthConstants.CACHING_DEFAULT.booleanValue());
        logger.debug("input auth context is {} with caching={}", (Object)import_context.toString(), (Object)caching);
        if (caching) {
            logger.debug("auth caching is enabled, will query cache pool with id={}", (Object)id);
            AuthCachePool authCachePool = AuthCachePool.getInstance();
            synchronized (authCachePool) {
                if (AuthCachePool.getInstance().containsKey(id)) {
                    auth_context = (AuthContext)AuthCachePool.getInstance().get(id);
                    logger.debug("auth context for id={} is found as {}", (Object)id, (Object)auth_context);
                } else {
                    logger.debug("auth context for id={} is not found, will try to login", (Object)id);
                    auth_context = authApi.login();
                    if (auth_context != null) {
                        logger.debug("login is successful, auth context for id={} will be cacahed as {}", (Object)id, (Object)auth_context);
                        AuthCachePool.getInstance().put(id, auth_context);
                    } else {
                        logger.info("no auth context required.");
                    }
                }
            }
        } else {
            auth_context = authApi.login();
        }
        return auth_context;
    }

    private void sleepForSometime() {
        Random random = this.workerContext.getRandom();
        int time = (10 + RandomUtils.nextInt((Random)random, (int)40)) * 100;
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new AuthInterruptedException((Throwable)e);
        }
        Logger logger = this.getMissionLogger();
        logger.debug("has waited for {} ms, will make a new attempt", (Object)time);
    }
}

