/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.agent;

import com.intel.cosbench.driver.agent.Agent;
import com.intel.cosbench.driver.agent.AgentException;
import com.intel.cosbench.driver.model.WorkerContext;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.service.AbortedException;

abstract class AbstractAgent
implements Agent {
    protected static final Logger LOGGER = LogFactory.getSystemLogger();
    protected WorkerContext workerContext;

    protected abstract void execute();

    public void setWorkerContext(WorkerContext workerContext) {
        this.workerContext = workerContext;
    }

    @Override
    public Agent call() throws Exception {
        int idx = this.workerContext.getIndex();
        try {
            this.execute();
            LOGGER.debug("agent {} exits normally", (Object)idx);
        }
        catch (AbortedException abortedException) {
            this.workerContext.setAborted(true);
            LOGGER.debug("agent {} has been aborted", (Object)idx);
        }
        catch (AgentException agentException) {
            this.workerContext.setError(true);
            LOGGER.debug("agent {} terminated with error", (Object)idx);
        }
        catch (Exception e) {
            this.workerContext.setError(true);
            LOGGER.error("unexpected exception", (Throwable)e);
            LOGGER.debug("agent {} terminated with error", (Object)idx);
        }
        return this;
    }

    protected Logger getMissionLogger() {
        return this.workerContext.getLogger();
    }
}

