/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.cdmiswift;

import com.intel.cosbench.client.cdmi.util.CdmiJsonInputStreamEntity;
import com.intel.cosbench.client.cdmiswift.CdmiSwiftClientException;
import com.intel.cosbench.client.cdmiswift.SwiftConflictException;
import com.intel.cosbench.client.cdmiswift.SwiftException;
import com.intel.cosbench.client.cdmiswift.SwiftFileNotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class CdmiSwiftClient {
    private static boolean REPORT_DELETE_ERROR = false;
    private HttpClient client;
    private String authToken;
    private String storageUrl;
    private static final String cdmi_ver = "1.0.1";

    public CdmiSwiftClient(HttpClient client) {
        this.client = client;
    }

    public void init(String authToken, String storageURL) {
        this.authToken = authToken;
        this.storageUrl = storageURL;
    }

    public void dispose() {
        this.client.getConnectionManager().shutdown();
    }

    public void createContainer(String container) throws IOException, SwiftException {
        HttpResponse response = null;
        try {
            HttpPut method = new HttpPut(String.valueOf(this.storageUrl) + "/" + CdmiSwiftClient.encodeURL(container));
            method.setHeader("Accept", "application/cdmi-container");
            method.setHeader("Content-Type", "application/cdmi-container");
            method.setHeader("X-CDMI-Specification-Version", cdmi_ver);
            method.setHeader("X-Auth-Token", this.authToken);
            response = this.client.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 201 || statusCode == 202) {
                return;
            }
            throw new SwiftException("unexpected return from server", response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public void deleteContainer(String container) throws IOException, SwiftException {
        HttpResponse response = null;
        try {
            HttpDelete method = new HttpDelete(String.valueOf(this.storageUrl) + "/" + CdmiSwiftClient.encodeURL(container));
            method.setHeader("X-CDMI-Specification-Version", cdmi_ver);
            method.setHeader("X-Auth-Token", this.authToken);
            response = this.client.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 204) {
                return;
            }
            if (statusCode == 404) {
                throw new SwiftFileNotFoundException("container not found: " + container, response.getAllHeaders(), response.getStatusLine());
            }
            if (statusCode == 409) {
                throw new SwiftConflictException("cannot delete an non-empty container", response.getAllHeaders(), response.getStatusLine());
            }
            throw new SwiftException("unexpected return from server", response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public InputStream getObjectAsStream(String container, String object) throws IOException, SwiftException {
        HttpResponse response = null;
        HttpGet method = new HttpGet(String.valueOf(this.storageUrl) + "/" + CdmiSwiftClient.encodeURL(container) + "/" + CdmiSwiftClient.encodeURL(object));
        method.setHeader("Accept", "application/cdmi-object");
        method.setHeader("X-CDMI-Specification-Version", cdmi_ver);
        method.setHeader("X-Auth-Token", this.authToken);
        response = this.client.execute((HttpUriRequest)method);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return response.getEntity().getContent();
        }
        if (statusCode == 404) {
            throw new SwiftFileNotFoundException("object not found: " + container + "/" + object, response.getAllHeaders(), response.getStatusLine());
        }
        throw new SwiftException("unexpected result from server", response.getAllHeaders(), response.getStatusLine());
    }

    private void dumpMethod(HttpRequestBase method) {
        System.out.println("==== METHOD BEGIN ====");
        System.out.println(method.getMethod());
        System.out.println(method.getURI());
        Header[] headerArray = method.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            System.out.println(String.valueOf(header.getName()) + ": " + header.getValue());
            ++n2;
        }
        System.out.println("==== METHOD END ====");
    }

    private void dumpResponse(HttpResponse response) {
        System.out.println("==== RESPONSE BEGIN ====");
        Header[] hdr = response.getAllHeaders();
        System.out.println("Headers : " + hdr.length);
        int i = 0;
        while (i < hdr.length) {
            System.out.println(hdr[i]);
            ++i;
        }
        System.out.println("---------");
        System.out.println(response.getProtocolVersion());
        System.out.println(response.getStatusLine().getStatusCode());
        System.out.println(response.getStatusLine().getReasonPhrase());
        System.out.println(response.getStatusLine().toString());
        System.out.println("---------");
        System.out.println("==== RESPONSE END ====");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeStreamedObject(String container, String object, InputStream data, long length) throws IOException, CdmiSwiftClientException {
        HttpPut method = null;
        HttpResponse response = null;
        try {
            method = new HttpPut(String.valueOf(this.storageUrl) + "/" + CdmiSwiftClient.encodeURL(container) + "/" + CdmiSwiftClient.encodeURL(object));
            method.setHeader("Accept", "application/cdmi-object");
            method.setHeader("Content-Type", "application/cdmi-object");
            method.setHeader("X-CDMI-Specification-Version", cdmi_ver);
            method.setHeader("X-Auth-Token", this.authToken);
            CdmiJsonInputStreamEntity entity = new CdmiJsonInputStreamEntity(data, length);
            if (length < 0L) {
                entity.setChunked(true);
            } else {
                entity.setChunked(false);
            }
            method.setEntity((HttpEntity)entity);
            response = this.client.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 201) {
                return;
            }
            if (statusCode == 202) {
                return;
            }
            if (statusCode != 404) throw new CdmiSwiftClientException(statusCode, "Unexpected Server Response: " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
            throw new FileNotFoundException("container not found: " + container);
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteObject(String container, String object) throws IOException, SwiftException {
        HttpResponse response = null;
        try {
            HttpDelete method = new HttpDelete(String.valueOf(this.storageUrl) + "/" + CdmiSwiftClient.encodeURL(container) + "/" + CdmiSwiftClient.encodeURL(object));
            method.setHeader("X-CDMI-Specification-Version", cdmi_ver);
            method.setHeader("X-Auth-Token", this.authToken);
            response = this.client.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 204) {
                return;
            }
            if (!REPORT_DELETE_ERROR) {
                return;
            }
            if (statusCode != 404) throw new SwiftException("unexpected return from server", response.getAllHeaders(), response.getStatusLine());
            throw new SwiftFileNotFoundException("object not found: " + container + "/" + object, response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public static String encodeURL(String str) {
        URLCodec codec = new URLCodec();
        try {
            return codec.encode(str).replaceAll("\\+", "%20");
        }
        catch (EncoderException encoderException) {
            return str;
        }
    }
}

